package ins.inr;

import java.util.*;

/**
 * This table holds a set of RouteTables for a set of vspaces,
 * with each RouteTable mapping INR announcer uids to RouteEntries.
 */

class VSRouteTable
    extends VSpaceSet
{

    // CONSTRUCTOR
    VSRouteTable()
    {
	super();
    }

    // METHODS
    void init(Resolver r)
    {

    }

    /**
     * adds a VSpace to the list.
     * if it already exists, returns false (otherwise true)
     */
    public synchronized boolean addVspace(String vspace, RouteTable r)
    {
	return super.addVspace(vspace, (RouteTable)r);
    }

    /**
     * Removes the vspace from the list and returns whether or not 
     * it was successful
     */
    public synchronized boolean removeVspace(String vspace) 
    {
	return super.removeVspace(vspace);
    }

    /**
     * Returns the RouteTable object associated with vspace
     */
    public synchronized RouteTable getNeighbors(String vspace)
    {
	return (RouteTable)(super.getVSpace(vspace));
    }

    /**
     * Looks up for the vspace the uid in the routetable
     *   and returns the result.
     */
    RouteEntry lookup(String vspace, long uid)
    {
	RouteTable rt = (RouteTable)rep.get(vspace);

	if (rt == null) 
	    return null;

	return rt.lookup(uid);
    }


    /*
     * Creates a RouteEntry and puts it in the RouteTable 
     *   for a given vspace.
     * Also produces the RouteTable if it doesn't already exist.
     */
    void add(String vspace, long uid, Node nextHop, int hop, 
	     int rtt, long lifetime)
    {
	RouteTable rt = (RouteTable)rep.get(vspace);

	if (rt == null)
	{
	    rt = new RouteTable();
	    rt.add(uid, nextHop, hop, rtt, lifetime);
	    rep.put(vspace, rt);
	}
	else
	{
	    rt.add(uid, nextHop, hop, rtt, lifetime);
	}
    }

    /**
     * Adds under a vspace's RouteTable a
     *   uid and its corresponding RouteEntry.
     */
    void add(String vspace, long uid, RouteEntry re)
    {
	if (!rep.containsKey(vspace))
	{
	    RouteTable rt = new RouteTable();
	    rt.add(uid, re);
	    rep.put(vspace, rt);
	}
	else
	{
	    RouteTable rt = (RouteTable)rep.get(vspace);
	    rt.add(uid, re);
	}
    }

    void remove(String vspace, long uid)
    {
	RouteTable rt = (RouteTable)rep.get(vspace);

	if (rt != null) 
	    rt.remove(uid);
	else
	    System.out.println("WARNING:  VSRouteTable contains no vspace " + vspace);
    }

    /**
     * Get all the entries in the RouteTable corresponding
     *   to a given vspace.
     */
    Enumeration getRouteEntries(String vspace)
    {
	RouteTable rt = (RouteTable)rep.get(vspace);
	
	if (rt == null)
	    return (new Vector(1)).elements();

	return rt.getRouteEntries();
    }

    /**
     * Returns a String representation of the VSRouteTable.
     */
    public String toString()
    {
	StringBuffer strbuf = new StringBuffer();

	strbuf.append("VSRouteTable has " + rep.size() + " vspaces.\n");
	for (Enumeration enum = rep.keys(); enum.hasMoreElements(); )
	{
	    Object vspace = enum.nextElement();
	    Object routetable = rep.get(vspace);

	    strbuf.append("VSPACE " + vspace.toString() + "\n");
	    strbuf.append(routetable.toString() + "\n");
	}
	return strbuf.toString();
    }


}
