package ins.inr;

import java.util.*;

/**
 * While not used directly anywhere, this serves as a superclass for
 * VSpaceResolvers/VSpaceNeighbors, and it can be used anywhere a 
 * set of vspaces needs to be related to a set of other pieces of
 * information.
 *
 */

class VSpaceSet
{
    protected Hashtable rep;

    VSpaceSet()
    {
	rep = new Hashtable(47);
    }

    /**
     * Adds a VSpace to the list.
     * if it already exists, returns false (otherwise true)
     *
     * @param vspace The vspace to add
     * @param o The object to add
     * @return Whether the vspace could be added.
     */
    public synchronized boolean addVspace(String vspace, Object o) 
    {
	if (rep.containsKey(vspace))
	    return false;

	rep.put(vspace, o);
	return true;
    }

    /**
     * Removes the vspace from the list and returns whether or not 
     * it was successful
     *
     * @param vspace The vspace to remove
     * @return Whether the action was successful
     */
    public synchronized boolean removeVspace(String vspace) 
    {
	return (rep.remove(vspace) != null);
    }


    /**
     * Returns the object associated with vspace
     *
     * @param vspace The vspace to look up
     * @return The associated object.
     */
    public synchronized Object getVSpace(String vspace)
    {
	return rep.get(vspace);
    }

    /**
     * Returns the enumeration of vspaces
     *
     * @return Enumeration of the applicable vspaces
     */
    public synchronized Enumeration getVspaces()
    {
	return rep.keys();
    }

}
