package ins.inr.twineStrandMapper;

import java.security.*;
import ins.inr.*;
import ins.inr.twineKeyRouter.*;
import cryptix.util.core.Hex;
import cryptix.provider.md.*;

/**
 * TwineStrandMapper.java <br>
 *
 * Maps a strand onto a numeric key
 * by concatenating all attributes
 * and values in the strand and by
 * computing an MD5 hash.
 * <br>
 * Created: Thu Jun 21 18:24:20 2001 <br>
 * Modified: $Id: TwineAtOnceStrandMapper.java,v 1.4 2002/03/21 00:01:55 mbalazin Exp $
 * 
 * @author Magdalena Balazinska
 */

public class TwineAtOnceStrandMapper extends TwineStrandMapper {

    //-----------------------------------------------------
    /** 
     *  
     */
    public TwineAtOnceStrandMapper() {

	super();
    }

    //-----------------------------------------------------
    /** 
     *  
     */
    public void send(String[] strand, int howMany, TwineMessage tm) {

	// Compute key for strand
	String key;
	byte[] hash;
	
	for ( int i = 0; i < strand.length; i++)
	    md.update(strand[i].getBytes());
	
	hash = md.digest();
	keyrouter.send(hash,howMany,tm);

    }

}
