package ins.inr.twineStrandMapper;

import java.security.*;
import ins.inr.*;
import ins.inr.twineKeyRouter.*;

/**
 * TwineStrandMapper.java
 *  <br>
 * Maps a strand onto a numeric key
 * by computing the hash value of 
 * each element of the
 * strand and by concatenating the 
 * hashes obtained.
 * <br>
 * Created: Thu Jun 21 18:24:20 2001 <br>
 * Modified: $Id: TwineConcatStrandMapper.java,v 1.3 2002/03/21 00:01:55 mbalazin Exp $
 * @author Magdalena Balazinska
 * 
 */

public class TwineConcatStrandMapper extends TwineStrandMapper {

    public int KEY_LENGTH = 16;
    public int BYTES_PER_ATTRIB = 1; 
    public int NB_ATTRIBS_FOR_KEY = KEY_LENGTH / BYTES_PER_ATTRIB;

    public TwineConcatStrandMapper() {
	super();
    }

    //-----------------------------------------------------
    /** 
     *  
     */
    public void send(String[] strand, int howMany, TwineMessage tm) {

	// Compute key for strand
	byte[] hash;
	byte[] key = new byte[KEY_LENGTH];
	
	int index = 0;
	for ( int i = 0; (i < NB_ATTRIBS_FOR_KEY) && (i < strand.length); i++) {
	    
	    md.update(strand[i].getBytes());
	    hash = md.digest();
	    System.arraycopy(hash, hash.length-BYTES_PER_ATTRIB, key, index, BYTES_PER_ATTRIB);
	    index += BYTES_PER_ATTRIB;
			     
	}
	keyrouter.send(key,howMany,tm);

    }
 
}
