package ins.inr.twineStrandMapper;

import java.security.*;
import java.net.*;
import ins.inr.*;
import ins.inr.twineKeyRouter.*;

/**
 * TwineStrandMapper.java <br>
 *
 * Abstract class to map strands
 * onto numeric keys. <br>
 *
 * Created: Thu Jun 21 18:24:20 2001 <br>
 * Modified: $Id: TwineStrandMapper.java,v 1.4 2002/03/21 00:01:55 mbalazin Exp $
 *
 * @author Magdalena Balazinska
 */

public abstract class TwineStrandMapper {

    protected TwineLogger log;
    protected MessageDigest md;   
    protected TwineKeyRouter keyrouter;   // Layer below
    protected TwineInterResolver resComm; // Layer above
    protected RPCCommunicator rpcComm;

    //-----------------------------------------------------
    /** 
     *  
     */
    public TwineStrandMapper() {

	log = new TwineLogger("TwineSM");
	keyrouter = new TwineKeyRouter();
	try {
            md = MessageDigest.getInstance("MD5");
        } catch ( NoSuchAlgorithmException e) {
            log.printStatus("\n No MD5 available",TwineLogger.KEY_MSG);
            System.exit(0);
        }

    }

    //-----------------------------------------------------
    /** 
     *  
     */
    public void init(RPCCommunicator c, TwineInterResolver tir) {
	rpcComm = c;
	resComm = tir;
	keyrouter.init(c,this);
    }


    //-----------------------------------------------------
    /** 
     *  
     */
    public void send(String[] attStrand, int howMany, TwineMessage tm) {
	return;
    }

    //-----------------------------------------------------
    /** 
     *  
     */
    public void sendRemove(TwineMessage tm) {
	keyrouter.sendRemove(tm);
    }


    //-----------------------------------------------------
    /** 
     *  
     */
    public void reSend(InetAddress addr,int port,Packet p,byte[] key) {
	keyrouter.reSend(addr,port,p,key);
    }

   
    //-----------------------------------------------------
    /** 
     *  
     */
    public void doneSending(int howMany, int seqNum) {

	resComm.doneSending(howMany,seqNum);

    }

}
