#ifndef chord_interface_h
#define chord_interface_h

#include "chord.h"
#include "parseopt.h"
#include "arpc.h"
#include "keyrouter_prot.h"

#define PORT_LENGTH 10
// The extra 2 chars are for the "0x"
#define KEY_LENGTH 42
#define MAX_VNODES 1024

#define PORT_OFFSET 1000

//---------------------------------------------------
/*
 * Creates, holds and interacts with a Chord node.
 * @author Magdalena Balazinska
 */
class chord_interface {

 private:
  ptr<chord> chordnode;
  int nb_vnodes;
  vnode* vnodes[MAX_VNODES];  

  void configureNode(int argc, char** argv);
  char* convertLength(const char* key);
  void initID(str s, chordID* ID);
  void initID(char* keystr, chordID* ID);

 public:
  chord_interface(int argc, char** argv);
  void printNodeInfo();
  void getNode(const char* key, svccb *sbp);
  void getNode_cb(svccb* sbp, chordID succ, route path, chordstat err);
  vnode* pickVnode(const char* key);
  void getNext(const char* key, svccb *sbp);
  void getKNext(const char* key, int howMany, svccb *sbp);
  void prepareNodeInfoRes(keyrouter_nodeinfo_res_ok* resok, chordID succ);
  void answerOK(svccb* sbp, chordID succ);
  void answerOK(svccb* sbp, chordID* successors, int howMany);
  void answerERR(svccb* sbp);
  void newvnode_cb(int n, vnode *my,chordstat stat);

};

#endif
