#include "arpc.h"
#include "keyrouter_prot.h"
#include "chord_interface.h"

ptr<asrv> keyroutesrv;

//---------------------------------------------------
ptr<chord_interface> ichord;

//---------------------------------------------------
/**
 * Main executable to create a thin client to use
 * Chord. This client implements the RPC interface
 * defined in <code>keyroutersvc</code>
 * We're currently NOT using the portmapper (for 
 * experiment purposes, we want to be able to run more 
 * than one process on any given machine). All
 * methods necessary to use the portmapper are left in 
 * comments
 * 
 * @author Magdalena Balazinska
 */



/*
 * Demultiplexing RPC calls from Java client
 * 
 */
// if using pormapper, use following header
// void dispatch (svccb *sbp) 
void
dispatch (ptr<asrv> s, ptr<axprt_dgram> x, svccb *sbp) 
{
  warn ("prog %d, vers %d, proc %d\n", sbp->prog (),
	sbp->vers (), sbp->proc ());

  assert(ichord);

  if (!sbp) {
    s->setcb(NULL);
    return;
  }

  switch (sbp->proc ()) {

  case KEYROUTERPROC_NULL:
    sbp->reply (NULL);
    return;

  case KEYROUTERPROC_GETNODE:
    {

      warn("\nKEYROUTER: lookup_request\n");
      keyrouter_key_arg *arg = sbp->template getarg<keyrouter_key_arg> ();
      const char* key = arg->key;

      // The getNode will reply directly to client
      ichord->getNode(key,sbp);

    } 
    break;

  case KEYROUTERPROC_GETNEXT:
    {

      warn("\nKEYROUTER: successor_request\n");
      keyrouter_key_arg *arg = sbp->template getarg<keyrouter_key_arg> ();
      const char* key = arg->key;

      // The getNode will reply directly to client
      ichord->getNext(key,sbp);

    } 
    break;

  case KEYROUTERPROC_GETKNEXT:
    {

      warn("\nKEYROUTER: k successor_request\n");
      keyrouter_kkey_arg *arg = sbp->template getarg<keyrouter_kkey_arg> ();
      const char* key = arg->key;
      const int howMany = arg->howMany;

      // The getNode will reply directly to client
      ichord->getKNext(key,howMany,sbp);

    } 
    break;
  default:
    sbp->reject (PROC_UNAVAIL);
    break;
  }

}


//---------------------------------------------------
/**
 */
extern "C" void 
usage() {

  warnx << "Usage: " << progname 
	<< " -j hostname:port -p myPort [-v <nvnode>]\n";
  warnx << progname << " will also use port (myPort - " << PORT_OFFSET << ")\n";
  exit (1);

}

//---------------------------------------------------
/** 
 * We're not using the portmapper. We explicitely bind to
 * a port given in parameters
 */
int
bindToPort (int myp)
{
  int srvfd = inetsocket (SOCK_DGRAM, myp);
  if (srvfd < 0)
    fatal ("binding UDP port %d: %m\n", myp);

  if (myp == 0) {
    struct sockaddr_in addr;
    socklen_t len = sizeof (addr);
    bzero (&addr, sizeof (addr));
    if (getsockname (srvfd, (sockaddr *) &addr, &len) < 0) 
      fatal ("getsockname failed %m\n");
    myp = ntohs (addr.sin_port);
  }

  ptr<axprt_dgram> x = axprt_dgram::alloc (srvfd, sizeof(sockaddr), 230000);
  ptr<asrv> s = asrv::alloc (x, keyrouter_program_1);
  s->setcb (wrap (dispatch, s, x));
  return myp;
}

//---------------------------------------------------
/**
 */
/*void
bindWithPortmapper() {

  int fd = inetsocket (SOCK_DGRAM);
  if (fd < 0)
    fatal ("socket: %m\n");
  ref<axprt> x (axprt_dgram::alloc (fd));

  keyroutesrv = asrv::alloc (x, keyrouter_program_1, wrap (dispatch));
  pmap_map (fd, keyrouter_program_1);

  }
*/

//---------------------------------------------------
/*
 *
 */
int
main (int argc, char **argv)
{

  // If we were using the portmapper
  // bindWithPortmapper();

  setprogname(argv[0]);

  // The following is to bind to a specific port
  int myp = -1;
  for ( int i = 0; i < argc - 1; i++) {
    if ( strcmp(argv[i],"-p") == 0) {
      myp = atoi(argv[i+1]);
      myp = bindToPort(myp); 
      break;
    }
  }

  if ( myp <= 0 )
    usage();

  sigcb (2, wrap (exit, 1));
  ichord = New refcounted<chord_interface>(argc,argv);
  
  amain ();
}


