package ins.keyrouters.javakeyrouter;

import org.acplt.oncrpc.*;
import java.net.InetAddress;
import java.io.*;
import ins.inr.TwineLogger;

   
//-----------------------------------------------------
/** 
 * Offers key routing capabilities to Java clients.
 * <br>
 * Returns resolvers that are associated with 
 * given keys. A client instantiates an object of this 
 * class and performs ordinary method calls.
 * This class forwards all calls to the actual service 
 * that provides the distributed hash-table functionality. 
 * The forwarding is done through an RPC interface defined
 * in <code>keyroutersvc</code> <br>
 * Beware! These calls are blocking. (Twine resolvers use
 * thread pools to make them async.)
 * <br>
 * @author Magdalena Balazinska
 */
public class KeyRouter {

    protected static String defaultIP = "127.0.0.1";
    protected keyrouter_protClient client = null;
    protected TwineLogger log = null;

       
    //-----------------------------------------------------
    /** 
     * Preparing the long lived client for the key router
     * that lives on the localhost. 
     * We'll keep asking that node about successors of keys.
     */
    public KeyRouter (String hostname, int port) {

	log = new TwineLogger("KeyRouter","KeyRouter.log");
	log.printStatus("Starting KeyRouter",TwineLogger.INFO_MSG);
	
	try {

	    if ( hostname == null )
		client = new keyrouter_protClient(InetAddress.getByName(defaultIP),port,
						  OncRpcProtocols.ONCRPC_UDP);
	    else
		client = new keyrouter_protClient(InetAddress.getByName(hostname),port,
						  OncRpcProtocols.ONCRPC_UDP);	

	    client.getClient().setTimeout(300*1000);
      
	} catch ( Exception e ) { e.printStackTrace(System.out); }
	
    }
   
    //-----------------------------------------------------
    /** 
     *  Finds the IP of the resolver associated with the given key
     */
    public keyrouter_nodeinfo_res getNode(String stringKey) {

	String hostname = "localhost";
	keyrouter_nodeinfo_res result = null;

	if ( client == null) {
	    System.out.println("\n Client is null!!!!");
	    System.exit(0);
	}
	    
	try {

	    keyrouter_key_arg queryArg = new keyrouter_key_arg();
	    queryArg.key = "0x" + stringKey;
	    
	    result = client.KEYROUTERPROC_GETNODE_1(queryArg);
	  
	} catch ( Exception e ) { e.printStackTrace(System.out); }
	
	return result;

    }
   
    //-----------------------------------------------------
    /** 
     * This method does an RPC call straight to the node
     * that we want to ask for its successor.
     */
    public keyrouter_nodeinfo_res getNext(String hostname, int port, String stringKey) {

	keyrouter_protClient shortClient = null;
 	keyrouter_nodeinfo_res result = null;

	try {

	    //keyrouter_netaddress addr = current.addr;
	    shortClient = new keyrouter_protClient(InetAddress.getByName(hostname),port,
						   OncRpcProtocols.ONCRPC_UDP);

	    keyrouter_key_arg queryArg = new keyrouter_key_arg();
	    queryArg.key = "0x" + stringKey;
	    
	    shortClient.getClient().setTimeout(300*1000);
	    result = shortClient.KEYROUTERPROC_GETNEXT_1(queryArg);
	
	    shortClient.close();
	    shortClient = null;

	} catch ( Exception e ) { e.printStackTrace(System.out); }
	
	return result;
    }


    //-----------------------------------------------------
    /** 
     * This method does an RPC call straight to the node
     * that we want to ask for its successors.
     */
    public keyrouter_knodeinfo_res getKNext(String hostname, int port, String stringKey,
					   int howMany) {

	keyrouter_protClient shortClient = null;
 	keyrouter_knodeinfo_res result = null;

	try {
	    shortClient = new keyrouter_protClient(InetAddress.getByName(hostname),port,
						   OncRpcProtocols.ONCRPC_UDP);

	    keyrouter_kkey_arg queryArg = new keyrouter_kkey_arg();
	    queryArg.key = "0x" + stringKey;
	    queryArg.howMany = howMany;
	    
	    shortClient.getClient().setTimeout(300*1000);
	    result = shortClient.KEYROUTERPROC_GETKNEXT_1(queryArg);
	
	    shortClient.close();
	    shortClient = null;

	} catch ( Exception e ) { e.printStackTrace(System.out); }
	
	return result;
    }

    //-----------------------------------------------------
    /** 
     *  
     */
    protected void finalize() {
	
	try {
	    client.close();
	    client = null;
	} catch ( Exception e ) { e.printStackTrace(System.out); }
    }

}
