const KEYROUTER_MAXSTRINGLENGTH	= 1024;
const KEYROUTER_MAXNODES = 20;

enum keyrouter_stat {
  KEYROUTER_OK = 0,
  KEYROUTER_ERR = 1
};

struct keyrouter_netaddress {
  string hostname<>;
  string port<>;
};

struct keyrouter_key_arg {
  string key<>;
};

struct keyrouter_kkey_arg {
  string key<>;
  int howMany;
};

struct keyrouter_nodeinfo_res_ok {
  keyrouter_netaddress addr;
  string key<>;
};

struct keyrouter_knodeinfo_res_ok {
  keyrouter_nodeinfo_res_ok list<KEYROUTER_MAXNODES>;
  int howMany;
};


union keyrouter_nodeinfo_res switch (keyrouter_stat status) {
  case KEYROUTER_OK:
    keyrouter_nodeinfo_res_ok resok;
  default:
    void;	
};

union keyrouter_knodeinfo_res switch (keyrouter_stat status) {
  case KEYROUTER_OK:
    keyrouter_knodeinfo_res_ok resok;
  default:
    void;	
};


program KEYROUTER_PROGRAM {
	version KEYROUTER_VERSION {

		void 
		KEYROUTERPROC_NULL (void) = 1;

		keyrouter_nodeinfo_res
		KEYROUTERPROC_GETNODE (keyrouter_key_arg) = 2;

		keyrouter_nodeinfo_res
		KEYROUTERPROC_GETNEXT (keyrouter_key_arg) = 3;

		keyrouter_knodeinfo_res
		KEYROUTERPROC_GETKNEXT (keyrouter_kkey_arg) = 4;
	} = 1;
} = 332222;


