#!/bin/perl
#
# phpify.pl -- Adjusts HTML javadoc files of the ACPLTea Java Library to
#              conform to the PHP design of the website of the
#              Chair of Process Control Engineering.
#

use strict "vars";
use strict "subs";

use File::Find;
use Cwd;

package main;

die "usage: $0 cvsify\n" unless @ARGV == 0;

sub scanDir {
    my $filename = $_;

    if ( -d $filename ) {
        return if $filename eq ".";
        my $dir = $File::Find::dir;
        $dir = $dir . "/" . $filename;
	print "\<DIR\> $dir\n";
#        if ( !-d $dir ) {
#	    mkdir($dir, 0777)
#		|| die "Can't make dir $dir";
#	}
	return;
    }
    return if $filename !~ /(.*)\.java/;
    &cvsify($filename);
}

find \&scanDir, "src";

#
# Read in each HTML file and copy it over to a PHP file with slight
# adjusments made to suit our page design.
#
sub cvsify {
    my ($source) = @_;

    print "$source\n";

    open(SOURCE, "< $source")
	|| die "Can't open $source";
    my @contents = <SOURCE>;
    close(SOURCE);

    open(DEST, "> $source")
	|| die "Can't write $source";

    my $i;
    my $size = @contents;
    my $line;

    for ( $i = 0; $i < $size; ++$i ) {
        $line = $contents[$i];
        if ( $line =~ /\@version \$Header: /var/cvs/ins/libs/remotetea/etc/cvsify.pl,v 1.1.1.1 2001/11/02 01:55:30 mbalazin Exp $/i ) {
            $line = " * \@version \$Revision\$ \$Date\$ \$State\$ \$Locker\$\n";
	}
        print DEST $line;
    }

    close(DEST);
}

# End of phpify.pl

