#!/bin/perl
#
# phpify.pl -- Adjusts HTML javadoc files of the ACPLTea Java Library to
#              conform to the PHP design of the website of the
#              Chair of Process Control Engineering.
#

use strict "vars";
use strict "subs";

use File::Find;
use Cwd;

package main;

die "usage: $0 javadocdir phpdocdir\n" unless @ARGV == 2;

my ($javadocdir, $phpdocdir) = @ARGV;
my $dirSkip = length $javadocdir;

#
# Recurse through all subdirectories, searching for HTML files. But remember
# to ignore the tests/ subdirectory. If a directory in the phpdocdir tree
# does not exist, then create it on the fly.
#
sub scanDir {
    my $filename = $_;

    if ( -d $filename ) {
        return if $filename eq ".";
        if ( $filename eq "tests" ) {
	    $File::Find::prune = 1;
	    return;
	}
        my $dir = substr $File::Find::dir, $dirSkip;
        $dir = $phpdocdir . "/" . $dir . "/" . $filename;
	print "\<DIR\> $dir\n";
        if ( !-d $dir ) {
	    mkdir($dir, 0777)
		|| die "Can't make dir $dir";
	}
	return;
    }

    return if $filename !~ /(.*)\.html/;
    my $phpfilename = $phpdocdir . "/" . 
                      (substr $File::Find::dir, $dirSkip) . 
                      "/" . $1 . ".php";
    if ( $filename =~ /-frame/ ) {
        open(SOURCE, "< $filename")
	    || die "Can't open $filename";
	my @contents = <SOURCE>;
	close(SOURCE);
	open(DEST, "> $phpfilename")
	    || die "Can't write $phpfilename";
	print DEST @contents;
	close(DEST);
    } else {
        &phpify($filename, $phpfilename);
    }
}

if ( !-d $phpdocdir ) {
    mkdir($phpdocdir, 0777)
	|| die "Can't make dir $phpdocdir";
}
&phpify($javadocdir . "/../readme-first/changelog.html", $phpdocdir . "/../changelog.php");
&phpify($javadocdir . "/../readme-first/changelog.remotetea.html", $phpdocdir . "/../changelog.remotetea.php", "Remote Tea Home Page", "http://www.plt.rwth-aachen.de/ks/english/remotetea.html");
find \&scanDir, $javadocdir;

#
# Read in each HTML file and copy it over to a PHP file with slight
# adjusments made to suit our page design.
#
sub phpify {
    my ($source, $dest, $linktext, $linkurl) = @_;

    if ( !defined $linktext ) {
        $linktext = "ACPLTea Java Library Home Page";
    }
    if ( !defined $linkurl ) {
        $linkurl = "http://www.plt.rwth-aachen.de/ks/english/acpltea.html";
    }

    print "$dest\n";

    open(SOURCE, "< $source")
	|| die "Can't open $source";
    my @contents = <SOURCE>;
    close(SOURCE);

    open(DEST, "> $dest")
	|| die "Can't write $dest";

    my $i;
    my $size = @contents;
    my $line;
    my $title = "";

    for ( $i = 0; $i < $size; ++$i ) {
        $line = $contents[$i];
        if ( $line =~ /<BODY.*>/i ) {
            my $anchor = "<a href=\\\"$linkurl\\\" target=\\\"_top\\\">$linktext</a>";
            my $image = "<img src=\\\"\".PicsPath().\"/home.gif\\\" width=14 height=14>&nbsp;";
            $line = "<?php\n" .
                    "    \$page_style = \"none\";\n" .
                    "    require(\"pagelayout.inc\");\n".
                    "    BeginBody(\"$title\");\n" .
                    "    echo(\"" . $image . $anchor . "<p>\\n\");\n" .
                    "?>";
	} elsif ( $line =~ /<\/BODY>/i ) {
            $line = "<?php EndBody(); ?>";
	} elsif ( $line =~ /<TITLE>/i ) {
            if ( $line =~ /<TITLE>(.+)<\/TITLE>/i ) {
                $title = $1;
                ++$i;
            } else {
                $title = $contents[$i+1];
                $i += 3;
            }
            while ( $title =~ /^\W/ ) {
                $title = substr $title, 1;
            }
            chomp $title;
            $line = "<title>" . $title . "</title>\n";
	}
        print DEST $line;
    }

    close(DEST);
}

# End of phpify.pl

