@echo off
if "%1" == "" goto help
if "%2" == "" goto help
if "%2" == "." goto help
if "%1" == "oncrpc" goto oncrpc
echo error: unknown package %1
goto end

:oncrpc
set package=oncrpc
set packagedirs=org\acplt\oncrpc tests\org\acplt\oncrpc
set packagename=remotetea
set packagejar=oncrpc.jar
set packages=org.acplt.oncrpc org.acplt.oncrpc.server org.acplt.oncrpc.apps.jrpcgen
goto copypackage

rem -------------------------------------------------------------------------------------
:copypackage
if exist %2 goto copypackage-1
mkdir %2
if errorlevel 1 goto end

:copypackage-1
echo Copying source code...
for %%d in (%packagedirs%) do xcopy ..\src\%%d %2\src\%%d /E/I/Q
if errorlevel 1 goto end

echo Copying classes...
for %%d in (%packagedirs%) do xcopy ..\classes\%%d %2\classes\%%d /E/I/Q
if errorlevel 1 goto end

echo Copying etc...
xcopy ..\etc %2\etc /E/I/Q

echo Creating documentation...
if exist %2\doc goto copypackage-2
mkdir %2\doc
:copypackage-2
copy ..\teabag.gif %2\doc
javadoc -d %2\doc -sourcepath ..\src -classpath ..\classes -private %packages%
rem xcopy ..\doc\%packagedir% %2\doc\%packagedir% /E/I/Q
if errorlevel 1 goto end

echo Copying project files...
copy ..\%packagename%.jpr %2
copy ..\%packagename%.dsk %2
copy ..\%packagename%.html %2
copy ..\Copying.lib %2
copy ..\teabag.gif %2

echo Copying readme, etc...
copy ..\readme.%packagename%.html %2
copy ..\changelog.%packagename%.html %2
echo Creating jar files...
call jarify.cmd %package% %2\classes

goto end

:help
echo usage: ripoff-package "package" "dir"
echo   valid values for "package" are: oncrpc
echo   "dir" specifies destination where to create the new package
:end
