package security.srp;


import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

public class PasswordEntryBox extends JFrame {
  private JPasswordField field;
  private JButton okay, clear, cancel;
  private String answer;
  private boolean selected;

  public PasswordEntryBox(String title, String prompt) {
    super(title);
    selected = false;
    answer = null;

//      this.getContentPane().setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

    this.getContentPane().setLayout(new BorderLayout());

    this.getContentPane().add(BorderLayout.NORTH, new JLabel(prompt));

    JPanel pp = new JPanel();
    field = new JPasswordField(10);
    field.setEchoChar('*');
    pp.setLayout(new FlowLayout(FlowLayout.CENTER, 10, 10));
    pp.add(field);

    this.getContentPane().add(BorderLayout.CENTER, pp);

    JPanel p = new JPanel();
    p.setLayout(new FlowLayout(FlowLayout.CENTER, 10, 10));
    okay = new JButton("OK");
    clear = new JButton("Clear");
    cancel = new JButton("Cancel");
    p.add(okay);
    p.add(clear);
    p.add(cancel);

    this.getContentPane().add(BorderLayout.SOUTH, p);

    ActionListener doneListener = new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	answer = new String(field.getPassword());
	close();
      }
    };

    okay.addActionListener(doneListener);
    field.addActionListener(doneListener);

    cancel.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	close();
      }
    });

    clear.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	field.setText("");
	field.requestFocus();
      }
    });

    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
	close();
      }
    });

    setSize(250, 100);
    show();

    field.requestFocus();
  }

  private synchronized void wakeup() { notifyAll(); }

  // Should be private, but a 1.1 compiler bug prevents us from doing that.
  void close() {
    selected = true;
    wakeup();
    setVisible(false);
    dispose();
  }

  public synchronized String getAnswer() {
    while(!selected)
      try {
        wait();
      } catch(InterruptedException e) {}
    return answer;
  }

  public static void main(String[] args) {
    PasswordEntryBox pe = new PasswordEntryBox("Enter password", "Enter SRP password");
    String p = pe.getAnswer();
    if(p == null)
      System.out.println("No password entered");
    else
      System.out.println("Password: " + p);
    System.exit(0);
  }
}
