package security.srp;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;

import java.io.*;
import java.util.*;
import java.net.*;
import java.security.*;
import java.math.BigInteger;

import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import xjava.security.Cipher;
import xjava.security.PaddingScheme;

import security.crypto.*;

class Client {

    public static final int KEY_LENGTH = 32;
    private byte[] sessionKey;


    private Socket socket;
    private BufferedReader in;
    private PrintWriter out;

    private void recRSAKeyPair(String epubStr, String emodStr,
			       String eprivStr) {
	byte[] epub = Hex.fromString(epubStr);
	byte[] emod = Hex.fromString(emodStr);
	byte[] epriv = Hex.fromString(eprivStr);

	Cipher alg = null;


	try {
	    alg = Cipher.getInstance("AES", "Cryptix");
	} catch (NoSuchAlgorithmException e) {
	    System.err.println("ERROR: Encryption Algorithm Not Found!");
	} catch (NoSuchProviderException e) {
	    System.err.println("ERROR: Provider Not Found!");
	}

	RawSecretKey key = new
	    RawSecretKey("AES", sessionKey);
	System.err.println("Key Length is: " + sessionKey.length);
	
	try {
	    if (!alg.isPaddingBlockCipher()) {
		System.err.println("Warning: Block Cipher does not pad!");
		PaddingScheme padscm = PaddingScheme.
		    getInstance("OneAndZeroes", "Cryptix");
		alg = Cipher.getInstance(alg,null,padscm);
	    }


	    alg.initDecrypt(key);
	    byte[] pub = alg.crypt(epub);
	    byte[] mod = alg.crypt(emod);
	    byte[] priv = alg.crypt(epriv);

	    BigInteger pk = new BigInteger(pub);
	    BigInteger md = new BigInteger(mod);
	    BigInteger sk = new BigInteger(priv);
	    

	    System.err.println(pk);
	    System.err.println(md);
	    System.err.println(sk);
	    
	} catch (KeyException e) {
	    e.printStackTrace();
	} catch (NoSuchAlgorithmException e) {
	    System.err.println("ERROR: Padding Algorithm Not Found!");
	} catch (NoSuchProviderException e) {
	    System.err.println("ERROR: Provider Not Found!");
	}
    }


    public Client(InetAddress addr, int PORT) {
	try {
	    socket = new Socket(addr, PORT);
	    in = new BufferedReader
		(new InputStreamReader
		    (socket.getInputStream()));
	    out = new PrintWriter
		(new BufferedWriter
		    (new OutputStreamWriter
			(socket.getOutputStream()), 128), true);
	} catch (IOException e) { e.printStackTrace(); }
	
	SRPClient cli = null;
	BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
	String u = null;
	
	try {
	    System.out.print("Enter username: ");
	    System.out.flush();
	    u = stdin.readLine();

	    out.println(u);

	    String str;
	    System.out.print("Enter n (from server): ");
	    System.out.flush();
//  	    str = stdin.readLine();
	    str = in.readLine();
	    System.out.println(str);
	    byte[] n = Util.fromb64(str);


	    System.out.print("Enter g (from server): ");
	    System.out.flush();
//  	    str = stdin.readLine();
	    str = in.readLine();
	    System.out.println(str);
	    byte[] g = Util.fromb64(str);

	    System.out.print("Enter salt (from server): ");
	    System.out.flush();
//  	    str = stdin.readLine();
	    str = in.readLine();
	    System.out.println(str);
	    byte[] salt = Util.fromb64(str);
	    
	    cli = new SRPClient(u, n, g, salt);
	    
	    byte[] ex = cli.generateExponential();
	    System.out.println("A (to server): " + Util.tob64(ex));
	    out.println(Util.tob64(ex));
	    
	    PasswordEntryBox peb = new PasswordEntryBox("Enter Password", "Please enter SRP password");
	    String password = peb.getAnswer();
	    
	    if(password == null)
		System.exit(1);
	    
	    System.out.print("Enter B (from server): ");
	    System.out.flush();
	    
//  	    str = stdin.readLine();
	    str = in.readLine();
	    System.out.println(str);
	    
	    cli.inputPassword(password);
	    byte[] key = cli.getSessionKey(Util.fromb64(str));
	    System.out.println("Session key: " + Util.tohex(key));
	    
	    sessionKey = new byte[KEY_LENGTH];
	    for (int i=0; i<KEY_LENGTH; i++)
		sessionKey[i] = key[i];

	    byte[] resp = cli.response();
	    System.out.println("Response (to server): " + Util.tohex(resp));
	    out.println(Util.tohex(resp));

	    String epubStr = in.readLine();
	    String emodStr = in.readLine();
	    String eprivStr = in.readLine();

	    recRSAKeyPair(epubStr, emodStr, eprivStr);
	    
	}
	catch(IOException e) {
	    e.printStackTrace();
	}
	finally {
	    System.exit(0);
	}
    
    }
}

/**
 * The Client-side interface to the SRP protocol.  This accepts and
 * generates the protocol messages, computes the final session key,
 * and performs authentication verification.  The task of transporting
 * the messages themselves across the network is left to the
 * implementor.
 */
public class SRPClient {
  private BigInteger n;
  private BigInteger g;
  private byte[] s;
  private BigInteger x;
  private BigInteger v;
  private BigInteger a;
  private BigInteger A;
  private String user;
  private byte[] key;
  private MessageDigest hash, ckhash;

  private static int A_LEN = 64;		// 64 bits for 'a'

  /**
   * Creates a new SRP Client object from the initial round of the
   * exchange.
   * @param username The user's username on the server host.
   * @param modulus The user's safe-prime modulus, received from
   *                the server.
   * @param generator The user's primitive generator, received from
   *                  the server.
   * @param salt The user's password salt, received from the server.
   */
  public SRPClient(String username, byte[] modulus, byte[] generator,
		   byte[] salt) {
    user = username;
    n = new BigInteger(1, modulus);
    g = new BigInteger(1, generator);
    s = salt;
    key = null;
    hash = Util.newDigest();
    hash.update(Util.xor(Util.newDigest().digest(modulus),
		      Util.newDigest().digest(generator), 20));
    hash.update(Util.newDigest().digest(username.getBytes()));
    hash.update(salt);
    ckhash = Util.newDigest();
  }

  /**
   * @returns The user's safe-prime modulus
   */
  public byte[] modulus() { return Util.trim(n.toByteArray()); }

  /**
   * @returns The user's primitive generator
   */
  public byte[] generator() { return Util.trim(g.toByteArray()); }

  /**
   * @returns The user's password salt
   */
  public byte[] salt() { return s; }

  /**
   * @returns The exponential residue (parameter A) to be sent to the
   *          server.
   */
  public byte[] exponential() {
    if(A == null) {
      BigInteger one = BigInteger.valueOf(1);
      do {
	a = new BigInteger(A_LEN, Util.RNG);
      } while(a.compareTo(one) <= 0);

      // A = g^a mod n
      A = g.modPow(a, n);
      byte[] out = Util.trim(A.toByteArray());
      hash.update(out);
      ckhash.update(out);
      return out;
    }
    else
      return Util.trim(A.toByteArray());
  }

  /**
   * Deprecated.  Use exponential() instead.
   */
  public byte[] generateExponential() { return exponential(); }

  /**
   * Incorporates the user's password into the session key computation.
   * @param pass The user's password or passphrase.
   */
  public void inputPassword(String pass) {
    MessageDigest ctxt = Util.newDigest();
    ctxt.update(s);
    ctxt.update(Util.userHash(user, pass));
    x = new BigInteger(1, ctxt.digest());
    v = g.modPow(x, n);
    System.err.println("Verifier is: " + Util.tob64(v.toByteArray()));
  }

  /**
   * @returns The secret shared session key between client and server
   * @param srvexp The server's exponential (parameter B).
   */
  public byte[] sessionKey(byte[] srvexp) {
    hash.update(srvexp);
    byte[] uhash = Util.newDigest().digest(srvexp);
    byte[] fourbytes = {uhash[0], uhash[1], uhash[2], uhash[3]};
    BigInteger sum = x.multiply(new BigInteger(1, fourbytes));
    BigInteger base = new BigInteger(1, srvexp);
    if(base.compareTo(v) < 0)
      base = base.add(n);
    base = base.subtract(v);
    BigInteger S = base.modPow(sum.add(a), n);
    key = Util.sessionKeyHash(Util.trim(S.toByteArray()));
    hash.update(key);
    return key;
  }

  /**
   * @returns The secret shared session key between client and server
   */
  public byte[] sessionKey() { return key; }

  /**
   * Deprecated.  Use sessionKey() instead.
   */
  public byte[] getSessionKey(byte[] srvexp) {
    return sessionKey(srvexp);
  }

  /**
   * @returns The response to the server's challenge.
   */
  public byte[] response() {
    byte[] resp = hash.digest();
    ckhash.update(resp);
    ckhash.update(key);
    return resp;
  }

  /**
   * @param resp The server's response to the client's challenge
   * @returns True if and only if the server's response was correct.
   */
  public boolean verify(byte[] resp) {
    return Util.matches(resp, ckhash.digest());
  }



  public static void main(String[] args) {
      try {
	  Client cli = new Client(InetAddress.getByName(args[0]),
				  new Integer(args[1]).intValue());
      } catch (UnknownHostException e) {
	  System.err.println("Error: Unknown host: " + args[0]);
      }
  }
}
