package security.srp;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;


import java.io.*;
import java.net.*;
import java.util.*;

import java.math.BigInteger;
import java.security.*;
import java.security.spec.*;
import javax.crypto.*;


import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import xjava.security.Cipher;
import xjava.security.PaddingScheme;

import security.crypto.*;

import ins.api.Application;
import ins.namespace.NameSpecifier;



class ServeClient extends Thread {

    public static final int KEY_LENGTH = 32;
    
    private SRPServer serv = null;
    private String u = null;
    
    private Socket socket;
    private BufferedReader in, stdin;
    private PrintWriter out, sockout;
    private StringTokenizer st;

    private byte[] sessionKey;
    
    public ServeClient(Socket s) throws IOException {
	socket = s;
	stdin = new BufferedReader(new InputStreamReader(System.in));
	in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
	out = new PrintWriter
	    (new BufferedWriter
		(new OutputStreamWriter(socket.getOutputStream())), true);

	sockout = new PrintWriter
	    (new BufferedWriter
		(new OutputStreamWriter(socket.getOutputStream())), true);
	
	start();
    }


    private void sendRSAPubKey(KeyPair kp) {
	byte[] pub = ((RSAPublicKey)kp.getPublic()).
				getPublicKey().toByteArray();
	byte[] mod = ((RSAPublicKey)kp.getPublic()).
				getModulo().toByteArray();

	sockout.println(Hex.toString(pub));
	sockout.println(Hex.toString(mod));
	
    }

	

    private void sendRSAKeyPair(KeyPair kp) {
	byte[] pub = ((RSAPublicKey)kp.getPublic()).
				getPublicKey().toByteArray();
	byte[] mod = ((RSAPublicKey)kp.getPublic()).
				getModulo().toByteArray();
	byte[] priv = ((RSAPrivateKey)kp.getPrivate()).
				 getPrivateKey().toByteArray();
	Cipher alg = null;


	try {
	    alg = Cipher.getInstance("AES", "Cryptix");
	} catch (NoSuchAlgorithmException e) {
	    System.err.println("ERROR: Encryption Algorithm Not Found!");
	} catch (NoSuchProviderException e) {
	    System.err.println("ERROR: Provider Not Found!");
	}

	RawSecretKey key = new
	    RawSecretKey("AES", sessionKey);
	System.err.println("Key Length is: " + sessionKey.length);
	
	try {
	    if (!alg.isPaddingBlockCipher()) {
		System.err.println("Warning: Block Cipher does not pad!");
		PaddingScheme padscm = PaddingScheme.
		    getInstance("OneAndZeroes", "Cryptix");
		alg = Cipher.getInstance(alg,null,padscm);
	    }


	    alg.initEncrypt(key);
	    byte[] epub = alg.crypt(pub);
	    byte[] emod = alg.crypt(mod);
	    byte[] epriv = alg.crypt(priv);

	    System.out.println(Hex.toString(epub));
	    System.out.println(Hex.toString(emod));
	    System.out.println(Hex.toString(epriv));

	    sockout.println(Hex.toString(epub));
	    sockout.println(Hex.toString(emod));
	    sockout.println(Hex.toString(epriv));

	    
	} catch (KeyException e) {
	    e.printStackTrace();
	} catch (NoSuchAlgorithmException e) {
	    System.err.println("ERROR: Padding Algorithm Not Found!");
	} catch (NoSuchProviderException e) {
	    System.err.println("ERROR: Provider Not Found!");
	}

	
    }


    private void refreshKeys(String u, PasswordFile pf) {
			System.out.println("Refreshing keys for [" + u +
				   "].  Groups: ");
		try {
		    ArrayList groups = serv.getGroups(u, pf);
		    for (int i=0; i<groups.size(); i++) {
			String gstr = (String)groups.get(i);
			String pfile = serv.getPKFilenameForGroup(gstr);
			String sfile = serv.getSKFilenameForGroup(gstr);

			PublicKey pk = null;
			PrivateKey sk = null;
			
			System.out.println("** " + gstr);

			System.out.println("group public key file: " + pfile);
			if (pfile != null)
			    pk = RSAKeyPairGenerator.readPubFromFile(pfile);
			System.out.println("group private key file: " + sfile);
			if (sfile != null)
			    sk = RSAKeyPairGenerator.readPrivFromFile(sfile);

			sendRSAKeyPair(new KeyPair(pk, sk));
		    }
		    
		} catch (NoSuchUserException e) { e.printStackTrace(); }
    }
    
    public void run() {
	PasswordFile pf=null;
	try {
	    pf = new PasswordFile();

	    System.out.print("Enter username: ");
	    System.out.flush();
	    u = in.readLine();
	    System.out.println(u);
	    serv = new SRPServer(u, pf);
	}
	catch(FileNotFoundException e) {
	    System.err.println("Password file not found");
	    System.exit(1);
	}
	catch(NoSuchUserException e) {
	    System.err.println("User " + u + " unknown");
	    System.exit(1);
	}
	catch(Exception e) {
	    e.printStackTrace();
	}
	
	System.err.println("n (to client): " + Util.tob64(serv.modulus()));
	System.err.println("g (to client): " + Util.tob64(serv.generator()));
	System.err.println("salt (to client): " + Util.tob64(serv.salt()));

	sockout.println(Util.tob64(serv.modulus()));
	sockout.println(Util.tob64(serv.generator()));
	sockout.println(Util.tob64(serv.salt()));
	sockout.flush();
	
	byte[] ex = serv.generateExponential();
	
	System.out.print("Enter B (from client): ");
	System.out.flush();
	try {
	    String astr = in.readLine();
	    System.out.println(astr);

	    // Must get A first before revealing B
	    System.out.println("B (to client): " + Util.tob64(ex));
	    sockout.println(Util.tob64(ex));
	    
	    byte[] key = serv.getSessionKey(Util.fromb64(astr));

	    sessionKey = new byte[KEY_LENGTH];
	    for (int i=0; i<KEY_LENGTH; i++)
		sessionKey[i] = key[i];

	    System.out.println("Session key: " + Util.tohex(key));
//  	    sockout.println(Util.tohex(key));
	    
	    System.out.print("Enter response (from client): ");
	    System.out.flush();
	    String resp = in.readLine();
	    System.out.println(resp);
	    
	    if(serv.verify(Util.fromhex(resp))) {
		System.out.println("Authentication successful.");
		refreshKeys(u, pf);
	    }
	    else {
		System.out.println("Authentication failed.");
		socket.close();
		return;
	    }
	}
	catch(IOException e) {
	    e.printStackTrace();
	}
    }
}


/**
 * The Server-side interface to the SRP protocol.  This accepts and
 * generates the protocol messages, computes the final session key,
 * and performs authentication verification.  The task of transporting
 * the messages themselves across the network is left to the
 * implementor.
 */
public class SRPServer {

    static final int PORT = 5001;
    static private ServerSocket servSock;
    static private Socket socket = null;

    private Hashtable pkeyHash;
    private Hashtable skeyHash;
    private static ArrayList userList;
    private static Announcer announcer;
    
    private BigInteger n;
    private BigInteger g;
    private BigInteger v;
    private byte[] s;
    private BigInteger b;
    private BigInteger B;
    private byte[] key;
    private MessageDigest hash, ckhash;

    private static int B_LEN = 64;	// 64 bits for 'b'

    public static final String defaultMod = "122401836212692490420534044542160652060089063288916259378992106298635997629004871449040863148842028332936921964140316531574725544295868627297697141329665138830185297018653829634397774436198765430305661897599443877203922836563409947444887027604848997125383124008931080480197775021431253630976071993683966590129";
    public static final String defaultGen = "164438241317367690823401305357370607328034430023459713340335187782878205902844516952738722877059454685668830995765089402230495206772108704026831761904445241536185572511706087329237156570564175356155697011727697175323622673030696046933358292860718413231660423149569049278930510073740541237052508995182528917163";

    private static void addUserCLUI(String username) {
	initUserList();
	BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
	try {
	    if (userList.contains(username)) {
		System.err.println("ERROR: User " + username +
				   " already exists.");
		return;
	    }
		
	    System.out.println("SRP server adding entry for " + username);
	    System.out.print("Modulus (n): ");
	    String modStr = stdin.readLine();
	    if (modStr.equals("")) {
		System.err.println("Using default modulus.");
		modStr = defaultMod;
	    }
	    System.out.print("Generator (g): ");
	    String genStr = stdin.readLine();
	    if (genStr.equals("")) {
		System.err.println("Using default generator.");
		genStr = defaultGen;
	    }
		
	    System.out.print("Salt: ");
	    String saltStr = stdin.readLine();
	    System.out.print("Group: ");
	    String groupStr = stdin.readLine();
	    
	    byte[] modulus = Util.fromb64(modStr);
	    byte[] generator = Util.fromb64(genStr);
	    
	    addUser(username, modulus, generator,
		    saltStr, groupStr, "/etc/tpasswd");
	} catch (IOException e) {
	    e.printStackTrace();
	}
    }
	
    
    private static void addUser(String username, byte[] modulus,
				byte[] generator, String saltStr,
				String groupstr, String pfString) {
	
	PasswordEntryBox peb = new PasswordEntryBox("Enter Password",
						    "Please enter SRP password");
	String password = peb.getAnswer();
	long uid = System.currentTimeMillis();
	byte[] s = Util.fromb64(saltStr);

	BigInteger n = new BigInteger(1, modulus);
	BigInteger g = new BigInteger(1, generator);

	MessageDigest ctxt = Util.newDigest();
	ctxt.update(s);
	ctxt.update(Util.userHash(username, password));
	BigInteger x = new BigInteger(1, ctxt.digest());
	BigInteger v = g.modPow(x, n);
	System.err.println("Verifier is: " + Util.tob64(v.toByteArray()));

	try {
	    FileOutputStream fos1 = new FileOutputStream(pfString, true);
	    PrintWriter out1 = new PrintWriter(new BufferedWriter
		(new OutputStreamWriter(fos1)), true);
	    out1.println(username + ":" + Util.tob64(v.toByteArray()) + ":" + 			   Util.tob64(s) + ":" + uid + ":" + groupstr);
	    
	    String confString = pfString + ".conf";
	    FileOutputStream fos2 = new FileOutputStream(confString, true);
	    PrintWriter out2 = new PrintWriter(new BufferedWriter
		(new OutputStreamWriter(fos2)), true);
	    out2.println(uid + ":" + Util.tob64(modulus )+ ":" +
			 Util.tob64(generator));
	} catch (FileNotFoundException e) {
	    System.err.println("Error: specified file not found");
	}
	
    }
    


  /**
   * Creates a new SRP Server object from the username (possibly
   * received from the client) and the PasswordFile containing the
   * password database.
   * @param username The user's username.
   * @param pw The password database.
   **/
  public SRPServer(String username, PasswordFile pw)
      throws NoSuchUserException, Exception {
//        super("18.24.6.251");

    String[] result = pw.lookup(username);
    if(result == null)
      throw new NoSuchUserException();
    v = new BigInteger(1, Util.fromb64(result[0]));
    s = Util.fromb64(result[1]);
    byte[] nb = Util.fromb64(result[3]);
    byte[] gb = Util.fromb64(result[4]);

    g = new BigInteger(1, gb);
    n = new BigInteger(1, nb);
    hash = Util.newDigest();

    ckhash = Util.newDigest();
    ckhash.update(Util.xor(Util.newDigest().digest(nb),
			   Util.newDigest().digest(gb), 20));
    ckhash.update(Util.newDigest().digest(username.getBytes()));
    ckhash.update(s);
    key = null;

    
    initKeyHash("keys.map");
    initUserList();
   
  }

    public void initKeyHash(String filename) {
	pkeyHash = new Hashtable();
	skeyHash = new Hashtable();
	
	FileInputStream fis = null;
	try {
	    fis = new FileInputStream(filename);
	} catch (FileNotFoundException e) {
	    System.err.println("ERROR: Key Hash File Not Found!");
	}
	    
	BufferedReader in = new BufferedReader
	    (new InputStreamReader(fis));

	String keyStr;
	try {
	    while ((keyStr = in.readLine()) != null) {
		
		StringTokenizer st = new StringTokenizer(keyStr, ":");
		String groupName = st.nextToken();
		String pkFile = st.nextToken();
		String skFile = st.nextToken();
		
		pkeyHash.put(groupName, pkFile);
		skeyHash.put(groupName, skFile);
	    }

	} catch (Exception e) { e.printStackTrace(); }
    }


    public static void initUserList() {
	userList = new ArrayList();
	FileInputStream fis = null;
	try {
	    fis = new FileInputStream("/etc/tpasswd");
	} catch (FileNotFoundException e) {
	    System.err.println("ERROR: Key Hash File Not Found!");
	}
	    
	BufferedReader in = new BufferedReader
	    (new InputStreamReader(fis));

	String keyStr;
	try {
	    while ((keyStr = in.readLine()) != null) {
		
		StringTokenizer st = new StringTokenizer(keyStr, ":");
		String username = st.nextToken();

		userList.add(username);
	    
	    }
	} catch (Exception e) { e.printStackTrace(); }
    }



    public String getPKFilenameForGroup(String grp) {
	return (String)pkeyHash.get(grp);
    }

    public String getSKFilenameForGroup(String grp) {
	return (String)skeyHash.get(grp);
    }

    
    public ArrayList getGroups(String username, PasswordFile pw)
	throws NoSuchUserException

    {
	String[] result = pw.lookup(username);
	ArrayList groups = new ArrayList();
	
	if (result == null)
	    throw new NoSuchUserException();
	String groupStr = result[5];
	StringTokenizer st = new StringTokenizer(groupStr, ",");
	while (st.hasMoreTokens())
	    groups.add(st.nextToken());

	return groups;
    }
	
	
  /**
   * @returns The user's safe-prime modulus
   */
  public byte[] modulus() { return Util.trim(n.toByteArray()); }

  /**
   * @returns The user's primitive generator
   */
  public byte[] generator() { return Util.trim(g.toByteArray()); }

  /**
   * @returns The user's password salt
   */
  public byte[] salt() { return s; }

  /**
   * @returns The exponential residue (parameter B) to be sent to the
   *          client.
   */
  public byte[] exponential() {
    if(B == null) {
      BigInteger one = BigInteger.valueOf(1);
      do {
	b = new BigInteger(B_LEN, Util.RNG);
      } while(b.compareTo(one) <= 0);
      B = v.add(g.modPow(b, n));
      if(B.compareTo(n) >= 0)
	B = B.subtract(n);
    }
    return Util.trim(B.toByteArray());
  }

  /**
   * Deprecated.  Use exponential() instead.
   */
  public byte[] generateExponential() { return exponential(); }

  /**
   * @param cliexp The client's exponential (parameter A).
   * @returns The secret shared session key between client and server
   */
  public byte[] sessionKey(byte[] cliexp) {
    byte[] B_arr = Util.trim(B.toByteArray());
    ckhash.update(cliexp);
    ckhash.update(B_arr);
    hash.update(cliexp);
    byte[] uhash = Util.newDigest().digest(B_arr);
    byte[] fourbytes = {uhash[0], uhash[1], uhash[2], uhash[3]};


    // (Av^u)^b mod n
    BigInteger S = new BigInteger(1, cliexp).
      multiply(v.modPow(new BigInteger(1, fourbytes), n)).mod(n);
    key = Util.sessionKeyHash(Util.trim(S.modPow(b, n).toByteArray()));
    ckhash.update(key);
    return key;
  }

  /**
   * @returns The secret shared session key between client and server
   */
  public byte[] sessionKey() { return key; }

  /**
   * Deprecated.  Use sessionKey() instead.
   */
  public byte[] getSessionKey(byte[] cliexp) { return sessionKey(cliexp); }

  /**
   * @returns The response to the client's challenge.
   */
  public byte[] response() {
    return hash.digest();
  }

  /**
   * @param resp The client's response to the server's challenge
   * @returns True if and only if the client's response was correct.
   */
  public boolean verify(byte[] resp) {
    if(Util.matches(resp, ckhash.digest())) {
      hash.update(resp);
      hash.update(key);
      return true;
    }
    else
      return false;
  }

    public static void startServer() {
	try {
	    ServerSocket servSock = new ServerSocket(PORT);
//  	    announcer = new Announcer();
	    
	    System.err.println("SRP-Based Group Manager Server started on port " + PORT);
	    while(true) {
		socket = servSock.accept();
		new ServeClient(socket);
	    }
	} catch (IOException ex) {
	    try {
		socket.close();
	    } catch (Exception ex1) {}
	} catch (Exception ex) { ex.printStackTrace(); 
	} finally {
	    try {
		servSock.close();
	    } catch (Exception ex) {}
	}
    }


  public static void main(String[] args) {
      if (args.length < 1) 
	  SRPServer.startServer();
      else {
	  SRPServer.addUserCLUI(args[0]);
      }
  }
}


class Announcer extends Application {

    public Announcer() throws Exception {
	super("18.24.6.251");
	initAnnouncer("keys.map");
    }
    
    public void initAnnouncer(String filename) {
	NameSpecifier gmName=null;
	String keyStr;
	String groupString = new String();
	StringBuffer sb = new StringBuffer(groupString);

	FileInputStream fis = null;
	try {
	    fis = new FileInputStream(filename);
	} catch (FileNotFoundException e) {
	    System.err.println("ERROR: Key Hash File Not Found!");
	}
	
	BufferedReader in = new BufferedReader
	    (new InputStreamReader(fis));
	
	try {
	    while ((keyStr = in.readLine()) != null) {
		StringTokenizer st = new StringTokenizer(keyStr, ":");
		String groupName = st.nextToken();
		sb.append(groupName + ",");
	    }

	    groupString = sb.toString();
	    gmName = new NameSpecifier("[service=GM][vspace=wind][groups=" +
				       groupString + "]");
	    
	} catch (Exception e) { e.printStackTrace(); }

	startAnnouncer(new NameSpecifier[] { gmName });
    }


}
