package ins.namespace;

/**
 * Represents an Attribute.
 */
public class Attribute
{
    // VARIABLES

    private String attribute;

    // CONSTRUCTORS

    /**
     * Creates an Attribute from string s.
     * @param s the wire representation of the Attribute.
     */
    public Attribute(String s)
    {
	attribute = s.trim();
    }

    /**
     * Creates an Attribute that's a copy of a.
     * @param a the Attribute to be copied.
     */
    public Attribute(Attribute a)
    {
	attribute = a.attribute;
    }

    // METHODS
    
    /**
     * Returns a String representation of the Attribute.
     * @return a human readable String that represents this Attribute.
     */
    public String toString()
    {
	return(attribute);
    }

    /**
     * Tests if an Attribute is equal to this Attribute.
     * @param a the Attribute to be tested.
     * @return true if a equals this Attribute, false otherwise.
     */
    public boolean equals(Attribute a)
    {
	return(attribute.equalsIgnoreCase(((Attribute)a).attribute));
    }


    public boolean equals(Object a)
    {
	if ((a==null) || (!(a instanceof Attribute))) return false;
	return(this.equals((Attribute)a));
    }

    /**
     * Tests if two Attributes are equal.
     * @param a1 one of the Attributes.
     * @param a2 the other Attribute.
     * @return true if a1 and a2 are equal, false otherwise.
     */
    public static boolean equal(Attribute a1, Attribute a2)
    {
	return(a1.equals(a2));
    }

}
