package ins.namespace;

import java.util.Vector;
import java.util.Enumeration;

/**
 * Represents a AttributeElement in a NameTree.
 */
class AttributeElement
{
    // VARIABLES
    
    Attribute a;
    private Vector children;     // Vector of ValueElement
                                 // (contains possible values)
    private ValueElement parent;
    
    // CONSTRUCTORS
    
    /**
     * Creates a AttributeElement with a as its Attribute.
     */
    AttributeElement(Attribute a)
    {
	this.a = a;
	children = new Vector(4);
	parent = null;
    }

    // METHODS
    
    /**
     * Sets the parent of this AttributeElement to be the ValueElement v.
     */
    void setParent(ValueElement v)
    {
      parent = v;
    }

    /**
     * Returns the parent of this AttributeElement.
     */
    ValueElement getParent()
    {
      return(parent);
    }

    /**
     * Add ValueElement v as a child of this AttributeElement.
     */
    void addValueElement(ValueElement v)
    {
        v.setParent(this);
	children.addElement((Object)v);
    }

    /**
     * Return a String representation of this sub-NameTree that is pretty,
     * and is indented to indentLevel.
     */
    String toPrettyString(int indentLevel)
    {
	String output = "";
	ValueElement v;

	for (int i = 0; i < indentLevel; i++)
	    output = output + "  ";
	output = output + a + "\n";

	for (Enumeration e = children.elements(); e.hasMoreElements(); ) {
	    v = (ValueElement)e.nextElement();
	    output = output + v.toPrettyString(indentLevel+1);
	}
	
	return(output);
    }

    /** 
     * Added by Magda to compute the size in terms of children nodes
     * and the node itself
     */
    public synchronized int size()
    {
	ValueElement v;
	int nbNodes = 0;
	for (Enumeration e = children.elements(); e.hasMoreElements(); ) {
	    v = (ValueElement)e.nextElement();
	    nbNodes = nbNodes + v.size();
	}
	// This node counts if it has any children
	if ( nbNodes != 0 )
	    nbNodes++;
	
	return nbNodes;
    }

    /**
     * Returns a String representation of the AttributeElement.
     */
    public String toString()
    {
	String output;
	ValueElement v;
	
	output = "(" + a; 

	for (Enumeration e = children.elements(); e.hasMoreElements(); ) {
	    v = (ValueElement)e.nextElement();
	    output = output + " " + v.toString();
	}

	output = output + ")";

	return(output);
    }

    /**
     * Returns the ValueElement with Value = v1, or throws an exception
     * if not found.
     */
    ValueElement findValueElement(Value v1)
	throws ElementNotFound
    {
	for (Enumeration e = children.elements(); e.hasMoreElements();) {
	    ValueElement ve = (ValueElement)e.nextElement();
	    Value v2 = ve.v;

	    if (v1.equals(v2)) {
		return(ve);
	    }
	}

	throw(new ElementNotFound());
    }

    /**
     * Returns an Enumeration of the ValueElements.
     */
    Enumeration getValueElements()
    {
	return(children.elements());
    }

}
