package ins.namespace;

import java.util.Date;

/**
 * Represents a Cached object.
 */
class Cache
{
  // VARIABLES

  private byte[] data;
  private Date expireTime;

  // CONSTRUCTORS

  /**
   * Creates a new, empty Cache.
   */
  Cache()
  {
    data = null;
  }

  /**
   * Creates a new Cache that contains data and has a lifetime of l ms.
   */
  Cache(byte[] data, long l)
  {
    this.data = data;
    
    Date now = new Date();
    expireTime = new Date(now.getTime() + l);
  }

  // METHODS

  /**
   * Updates the Cache with data and a lifetime of l ms.
   */
  void update(byte[] data, long l)
  {
    this.data = data;
    
    Date now = new Date();
    expireTime = new Date(now.getTime() + l);
  }

  /**
   * Returns true if Cache contains valid data.
   */
  boolean valid()
  {
    // If we don't have any data, return false.
    if (data == null) 
      return(false);

    // If the data has expired, return false.
    Date now = new Date();
    if (now.after(expireTime)) {
      // Junk the data.
      data = null;
      return(false);
    }

    return(true);
  }

  /**
   * Returns the data in the cache, or returns null if none.
   */
  byte[] getData()
  {
    if (valid())
      return(data);
    else
      return(null);
  }
}
