package ins.namespace;

import java.util.Vector;
import java.util.Enumeration;
import java.util.StringTokenizer;

/**
 * Implements a NameSpecifier.
 */
public class NameSpecifier extends AVelement
{
    // VARIABLES
  
    // all inherited from AVelement
    // a and v are not used

    private static Attribute vspaceAttr=new Attribute("vspace");

    /**
     * Creates a new, empty NameSpecifier. This is the default constructor.
     */
    public NameSpecifier()
    {
	super();
    }

    /**
     * Creates a NameSpecifier that is a copy of ns.
     * @param ns the NameSpecifier to be copied.
     */
    public NameSpecifier(NameSpecifier ns)
    {
	super();

	for (Enumeration e = ns.getAVelements(); e.hasMoreElements(); ) {
	    addAVelement(new AVelement((AVelement)e.nextElement()));
	}
    }

    /**
     * Creates a NameSpecifier.
     * @param s the String to create the NameSpecifier from
     * @exception CantParseString the String given was bad
     */
    public NameSpecifier(String s)
	throws CantParseString
    {
	super();

	StringTokenizer st;
	int level;    // bracket nesting level
	String next;  // the next token
	String child; // the current AVelement string
    
	st = new StringTokenizer(s, "[]", true);
	
	while (st.hasMoreTokens()) {
	    
	    // The child starts when we reach a "[" (and includes it).
	    child = "";
	    while (st.hasMoreTokens()) {
		child = st.nextToken();
	
		// System.out.println("NS1={"+child+"}");
		if (child.equals("["))
		    break;
	    }
	    
	    // We're inside the child, so we're at level 1.
	    level = 1;	
	    
	    while (st.hasMoreTokens()) {
		// Append the token to the child.
		next = st.nextToken();
		child = child + next;
		
		// System.out.println("NS2: "+child);
	
		// Keep track of brackets to figure out when the child
		// has ended. "[" indicates another level of nesting
		// within the child; "]" indicates a level of nesting has
		// finished. When we go back down to level 0, this child
		// is done.
		if (next.equals("[")) {
		    level++;
		} else if (next.equals("]")) {
		    level--;
		    if (level == 0)
			break;
		}
	    }
	    
	    // Create the AVelement from the child string 
	    // and add it to our list.
	    AVelement c = new AVelement(child);
	    addAVelement(c); // super?
	}
    }

    /** Adds the vspace to the NameSpecifier 
     * returns whether or not anything had to change.
     * if null is there, it puts no vspace entry/takes away any that exists
     */
    public boolean setVspace(String vspace) 
    {
	AVelement result = this.getAVelement(vspaceAttr);

	if (result == null) {
	    if (vspace == null) {return false; }
	    Value val = new Value(vspace);
	    this.addAVelement(new AVelement(vspaceAttr, val)); return true; 
	} else {
	    if (vspace == null) { this.removeAVelement(result); return true; }
	    Value val = new Value(vspace);

	    if (val.equals(result.getValue())) // if it's the same
		return false;
	    else {
		result.setValue(val);  // otherwise, change it
		return true;
	    }
	}
    }

    /** Gets the vspace from the NameSpecifier */
    public String getVspace( ) 
    {
 	AVelement result = this.getAVelement(vspaceAttr);

	if (result == null) return null;
	return result.getValue().toString();
    }

    /** Returns an array of vspaces */
    public String [] getVspaces() 
    {
 	AVelement result = this.getAVelement(vspaceAttr);

	if (result == null) return null;
	StringTokenizer st=new StringTokenizer(result.getValue().toString(),",; ");
	
	String [] sa = new String[st.countTokens()];
	int ctr=0;

	while (st.hasMoreTokens()) {
	    String s=st.nextToken();
	    sa[ctr++] = s;
	}
	return sa;
    }

}



