package ins.namespace;

import java.util.Vector;
import java.util.Enumeration;

public interface NameStoreInterface {

    public void setVspace(String vspace);
    
    /**
     * Lookup NameSpecifier s in the NameTree, and return its NameRecordSet.
     */
    public NameRecord[] lookup(NameSpecifier s);

    /**
     * Adds NameRecord r for NameSpecifier s to this NameTree.
     * Overrides addNameRecord in ValueElement.
     */
    public void addNameRecord(NameSpecifier ns, NameRecord r);

    /**
     * Extracts and returns the NameSpecifier associated with the NameRecord r.
     */
    public NameSpecifier extract(NameRecord r);

    /**
     * Removes NameRecord r from this NameTree.	
     * For now, it only removes the entry from Vector
     * later will add code to remove the unused branches of the NameTree
     */
    public void removeNameRecord(NameRecord r);

    /**
     * Returns an Enumeration of the NameRecords in this NameTree.
     */
    public Enumeration getNameRecords();

    /** Is this an aggregate vspace */
    public boolean isAggregateVspace();

    public void makeAggregateVspace();

    /**
     * Returns an String that is a printed version of the NameRecords.
     */
    public String nameRecordsToString();

    /**
     * Return a String representation of this NameTree that is pretty.
     * Overrides toPrettyString in ValueElement.
     */
    public String toPrettyString();

    /**
     * Returns a String representation of this NameTree.
     * Overrides toString in ValueElement.
     */
    public String toString() ;
}

