package ins.namespace;

import java.util.Vector;
import java.util.Enumeration;

/**
 * This class implements a tree that stores routing information.
 */
public class NameTree extends ValueElement implements NameStoreInterface
{
    // VARIABLES

    // v is not used.

    private Vector nameRecords; // Vector of NameRecord
    // (contains all NameRecord objects)
    // used to do an iteration over all of the NameRecords
    // but whoops, it looked like I deleted the storage of backpointer
    // information in the NameRecord because I forgot why I put it in <sigh>

    // vspace it services 
    private String vspace=null;
    
    // are we an aggregate vspace? (used to union smaller vspaces)
    private boolean aggregate=false;

    
    // CONSTRUCTORS

    /**
     * Creates an empty NameTree.
     */
    public NameTree()
    {
	super(null);
	nameRecords = new Vector();
	this.vspace = null;
    }

    public void setVspace(String vspace)
    {
	this.vspace = vspace;
    }
    
    // METHODS

    /**
     * Lookup NameSpecifier s in the NameTree, and return its NameRecordSet.
     */
    public synchronized NameRecord[] lookup(NameSpecifier s)
    {
	//System.out.println("lookup " + s.toString());
	NameRecordSet rs = super.lookup((AVelement)s);
	
	return(rs.toArray());
    }	    

    /**
     * Adds NameRecord r for NameSpecifier s to this NameTree.
     * Overrides addNameRecord in ValueElement.
     */
    public synchronized void addNameRecord(NameSpecifier ns, NameRecord r)
    {
	// Add r to the list of all Route Entries.
	nameRecords.addElement(r);

	// System.out.println("ADDING: " + ns.toString());
	// Now recursively add the Route Entry to the tree.
	super.addNameRecord((AVelement)ns, r);

	//ns.setVspace(vspace);
    }


    /**
     * Extracts and returns the NameSpecifier associated with the NameRecord r.
     */
    public synchronized NameSpecifier extract(NameRecord r)
    {
	NameSpecifier n = new NameSpecifier();
	Vector touched = new Vector(); // Vector of ValueElement

	// Precondition: all PTR's in the NameTree are null

	// Set the root to the new NameSpecifier, 
	// and add it to the touched list
	PTR = n;
	touched.addElement((ValueElement)this);

	// For each parent of the NameRecord
	for (Enumeration e = r.getParents(); e.hasMoreElements(); ) {
	    ValueElement v = (ValueElement)e.nextElement();

	    // Trace its way up to an AVE we've filled in already.
	    v.extractTrace((AVelement)null, touched);
	}

	// Clear all the pointers we've touched
	for (Enumeration e = touched.elements(); e.hasMoreElements(); ) {
	    ValueElement v = (ValueElement)e.nextElement();

	    v.PTR = null;
	}

	n.setVspace(vspace);

	return(n);
    }

    /**
     * Removes NameRecord r from this NameTree.	
     * For now, it only removes the entry from Vector
     * later will add code to remove the unused branches of the NameTree
     */
    public synchronized void removeNameRecord(NameRecord r)
    {
	if (nameRecords.removeElement(r))
	    r.removeParentPointers();
	else
	    System.out.println("NameTree: can not remove this record: "+r.toString());
    }

    /**
     * Returns an Enumeration of the NameRecords in this NameTree.
     */
    public synchronized Enumeration getNameRecords()
    {
	return(nameRecords.elements());
    }


    /** Is this an aggregate vspace */
    public boolean isAggregateVspace()
    {
	return aggregate;
    }

    public void makeAggregateVspace()
    {
	aggregate = true;
    }

    /**
     * Returns an String that is a printed version of the NameRecords.
     */
    public synchronized String nameRecordsToString()
    {
	String output = "";

	for (Enumeration e = nameRecords.elements(); e.hasMoreElements(); ) {
	    NameRecord re = (NameRecord)e.nextElement();
	    NameSpecifier ns = extract(re);
	    output = output + 
		"For NameRecord:\n  " + re + "\n" + 
		"The NameSpecifier is:\n  " + ns + "\n";
	}
    
	return(output);
    }

    /**
     * Return a String representation of this NameTree that is pretty.
     * Overrides toPrettyString in ValueElement.
     */
    public synchronized String toPrettyString()
    {
	String output = "RT: ";

	output = output + super.toPrettyString(0);

	return(output);
    }

    /** 
     * Added by Magda to compute the size of a NameTree in terms of its nodes
     */
    public synchronized int size()
    {
	return super.size();
	}

    /**
     * Returns a String representation of this NameTree.
     * Overrides toString in ValueElement.
     */
    public synchronized String toString() 
    {
	String output = "VSPACE: " + ((vspace==null)?"null":vspace) + " RT: ";

	output = output + super.toString();

	return(output);
    }
}

