package ins.namespace;

/**
 * Represents a Value.
 */
public class Value
{
  // VARIABLES

  private String value;
  private boolean wildcard;

  // Representation Invariant:
  // wildcard == true -> String == null
  // wildcard != true -> String != null

  // CONSTRUCTORS

  /**
   * Creates a Valuer from string s.
   * @param s the wire representation of the Value.
   */
  public Value(String s)
  {
    // Remove any extra spaces around the string, 
    // since they're not part of the value. 
    value = s.trim();

    if (value.equals("*")) {
      // wildcard
      value = null;
      wildcard = true;
    } else {
      wildcard = false;
    }
  }

  /**
   * Creates a Value that's a wildcard.
   */
  public Value()
  {
    value = null;
    wildcard = true;
  }

    /**
     * Creates a Value that's a copy of v.
     * @param v the Value to be copied.
     */
    public Value(Value v)
    {
	value = v.value;
	wildcard = v.wildcard;
    }

  // METHODS
    
  /**
   * Returns a String representation of the Value.
   * @return a human readable String that represents this Value.
   */
  public String toString()
  {
    if (wildcard)
      return("*");
    else
      return(value);
  }

  /**
   * Tests if a Value is equal to this Value.
   * @param v the Value to be tested.
   * @return true if v equals this Value, false otherwise.
   */
  public boolean equals(Value v)
  {  
    // Values are case-insensitive.
    if (wildcard || ((Value)v).wildcard)
      return(true);

    return(value.equalsIgnoreCase(((Value)v).value));
  }

  public boolean equals(Object v)
  {
    if ((v == null) || (!(v instanceof Value))) return false;
    return (this.equals((Value)v));
  }

  /**
   * Tests if two Values are equal.
   * @param v1 one of the Values.
   * @param v2 the other Value.
   * @return true if v1 and v2 are equal, false otherwise.
   */
  public static boolean equal(Value v1, Value v2)
  {
    return(v1.equals(v2));
  }

  /**
   * Tests if a Value is a wildcard.
   * @return true if the Value is a wildcard, false otherwise.
   */
  public boolean isWildcard()
  {
    return(wildcard);
  }

}
