package ins.namespace.index;

import java.util.*;
import ins.namespace.*;

public class DocList {
    
    public int[] docs;

    public int nextIncrement, length, capacity;

    DocList(int initialSize, int firstVal) {
	nextIncrement = initialSize *2;
	capacity = initialSize;
	length = 1;
	docs = new int[initialSize];
	docs[0] = firstVal;
    }
    
    // have to use since arrays.length does not give true number of elts..
    public int size() {
	return length;
    }

    // probably faster to get the docs field manually since this incurs calling convention
    // overhead
    public int[] docs() {
	return docs;
    }
    
    boolean insert(int name) {
	
	int left = 0, right = length, pivot;
	
	// bsearch to find where to insert..
	while (left < right)   {

	    pivot = ((right + left) >> 1); //divide by 2..
	    
	    if (name < docs[pivot]) {
		right = pivot;
	    }
	    else if (name > docs[pivot]) {
		left = pivot+1;
	    }
	    else {
		// found
		// already there.. do nothing then..
		System.out.println("Insert: element '"+ name +"' already present - insert failed.");
		return true;
	    }

	}
	
	//Assert.assert((left != right), "Index.rawInsert, left > right"); 

	// current arrays are too small to support another insert
	if (length >= capacity) {
	    // need to grow everyone
	    // resize
	    int[] tmpDocs = null;
	    tmpDocs = new int[capacity + nextIncrement];
	    capacity = capacity+nextIncrement;
	    // exponentially increase growth factor
	    nextIncrement = nextIncrement * 2;
	    
	    System.arraycopy(docs, 0, tmpDocs, 0, length);

	    docs = tmpDocs;

	}

	// move elements out of the way for the new one we are about to insert
	//for (int j = indexSize-1; j >= left; j--) {
	//    
	//}
	// this should be faster..
	if (length - left > 0) {
	    System.arraycopy(docs, left, docs, left+1, length-left);
	}
	
	docs[left] = name;
	
	length++;
	
	return false;
    }
	

    boolean delete(int name) {
	
	int left = 0, right = length, pivot;
	
	// bsearch to find where to insert..
	while (left < right)   {

	    pivot = ((right + left) >> 1); //divide by 2..
	    
	    if (name < docs[pivot]) {
		right = pivot;
	    }
	    else if (name > docs[pivot]) {
		left = pivot+1;
	    }
	    else {
		//		try {
		    System.arraycopy(docs, pivot+1, docs, pivot, length-(pivot+1));
//  		}catch (java.lang.ArrayIndexOutOfBoundsException e) {
//  		    System.out.println("pivot: "+pivot);
//  		    System.out.println("length: "+length);
//  		    System.out.println("docs.length: "+docs.length);
//  		    System.out.println(this.toString());
//  		    System.exit(1);
//  		}
		length--;
		return false;
	    }

	}
	// if gets here.. element not there.. scream!!
	
	//System.out.println("Delete: element '"+name+"' not found - delete failed");
	return true;
    }
    
    public String toString() {
	StringBuffer sb = new StringBuffer(length);
	for (int i = 0; i<(length-1); i++) {
	    sb.append(docs[i]);
	    sb.append(' ');
	}
	sb.append(docs[length-1]);
	return sb.toString();
    }



    // none of the input arguments are mutated.
    // intersect
    // parameters:
    // Object[] lists - array of arrays each of which are the arrays from doclists
    // int[]    lengths - corresponding lengths of each of the arrays in lists
    // int[]    positions - corresponding to each array all initted to 0
    // int      numLists - number of elements in lists and lengths
    // int      minSize - the minimum size of all the lists
    // returns:
    // Array of NameRecords..
    static int[] intersect(Object[] lists, int[] lengths, int[] positions, int numLists, int minSize) {
	
	int outputCount                   = 0; // used to generate final array
	int[] storeArray          = new int[minSize];
	int[] outputArray          = null;
	int currentList =                   1; // the current list being examined..
	                                       // start at the second one
	int compareNum     =                   -1; // current number being analyzed
	int listCount   =                   1;  // number of lists this value is in..

	compareNum = ((int[])lists[0])[0]; // initialize for the first one..

	LIST: while (true) {
	    if (compareNum > ((int[])lists[currentList]) [positions[currentList]]) {
		// we have to walk the list case
		positions[currentList]++;
		POSITION: while (positions[currentList] < lengths[currentList]) {
		    if (compareNum >  ((int[])lists[currentList])[positions[currentList]]) {
			// still too low.. march on..
			positions[currentList]++;
		    }
		    else {
			continue LIST; // back to normal
		    }
		}
		// if we get out here it means that we have nothing...
		// and we shoud bail..
		
		break;
	    }
	    else {
		if (compareNum == ((int[])lists[currentList])[positions[currentList]]) {
		    listCount++; // ad 1 to the totall if it gets to all then full
		    if (listCount == numLists) {
			// we got ourselves a canidate..
			storeArray[outputCount] = compareNum;
			outputCount++;
			listCount = 1;
			positions[currentList]++;
			if (positions[currentList] < lengths[currentList]) {
			    // update and roll..
			    compareNum = ((int[])lists[currentList])[positions[currentList]];
			    continue LIST; // don't want to incrment line number..
			}
			else {
			    // end..
			    break;
			}
		    }
		    // advance list
		} 
		else if (compareNum < ((int[])lists[currentList])[positions[currentList]]) {
		    // essentially a reset.. the curNumber is dead..
		    listCount = 1; // reset
		    compareNum = ((int[])lists[currentList])[positions[currentList]];
		}
		
		currentList ++; // move to the next list..
		if (currentList == numLists) {
		    currentList = 0;  // if end of list is encountered wrap around
		}
	    }
	}
	
	if (outputCount > 0) {
	    outputArray = new int[outputCount];
	    System.arraycopy(storeArray, 0, outputArray, 0, outputCount);
	    return outputArray;
	}
	else {
	    return null;
	}

    }

    public static void main(String argv[]) {
	Object[] outer = new Object[4];
	
	int[] results = null;

	DocList d1 = new DocList(2, 3);
	DocList d2 = new DocList(3, 15);
	DocList d3 = new DocList(2, 1300);
	DocList d4 = new DocList(3, 40);

	int[] num1 = {3, 7, 12, 16, 1020};
	System.out.println("d1: "+d1);
	d1.insert(7);
	System.out.println("d1: "+d1);
	d1.insert(12);
	System.out.println("d1: "+d1);
	d1.insert(16);
	System.out.println("d1: "+d1);
	d1.insert(16);
	System.out.println("d1: "+d1);
	d1.insert(1000);
	System.out.println("d1: "+d1);
	System.out.println("*** delete ****");
	d1.delete(15);
	System.out.println("d1: "+d1);
	int[] num2 = {7, 15, 28, 1050};
	System.out.println("d2: "+d2);
	d2.insert(1050);
	System.out.println("d2: "+d2);
	d2.insert(7);
	System.out.println("d2: "+d2);
	d2.insert(28);
	System.out.println("d2: "+d2);
	int[] num3 = {6, 9, 10, 14, 1300};
	System.out.println("d3: "+d3);
	d3.insert(14);
	System.out.println("d3: "+d3);
	d3.insert(7);
	System.out.println("d3: "+d3);
	d3.insert(9);
	System.out.println("d3: "+d3);
	d3.insert(6);
	System.out.println("d3: "+d3);
	int[] num4 = {7, 12, 40, 1002};
	System.out.println("d4: "+d4);
	d4.insert(1002);
	System.out.println("d4: "+d4);
	d4.insert(7);
	System.out.println("d4: "+d4);
	d4.insert(12);
	System.out.println("d4: "+d4);

	int[] lengths = {d1.size(), d2.size(), d3.size(), d4.size()};

	int[] positions = {0, 0 , 0 , 0};

	outer[0] = d1.docs;
	outer[1] = d2.docs;;
	outer[2] = d3.docs;
	outer[3] = d4.docs;
	
	results = intersect(outer,  lengths, positions, 4, 4) ;

	if (results == null) {
	    System.out.print("empty...");
	}
	else {

	    for (int i = 0; i<results.length; i++) {
		System.out.print(results[i]+", ");
	    }
	}
	System.out.println("andrew");
	
	
	return ;
    }

}
