
package ins.namespace.index;

import java.security.*;
import java.util.*;

public class Hash implements Cloneable{
    
    MessageDigest[] hashPool = null;
    IntStack freeStack = null;
    Hashtable reverseMap = null;

    int nextIncrement;

    
    // recommend something small.. like 5...
    public Hash(int initialPoolSize) {
	reverseMap = new Hashtable(initialPoolSize);
	freeStack = new IntStack(initialPoolSize);
	hashPool = new MessageDigest[initialPoolSize];
	for (int i=0; i < initialPoolSize; i++) {
	    try {
		hashPool[i] = MessageDigest.getInstance("MD5");
	    }
	    catch (NoSuchAlgorithmException e) {
		System.out.println("We're screwed.. MD5 is not installed");
		System.exit(1);
	    }
	    freeStack.push(i);
	    reverseMap.put(hashPool[i], new Integer(i));
	}
	nextIncrement = 2* initialPoolSize;
    }

    public synchronized MessageDigest getHash() {
	if (freeStack.empty()) {
	    // empty .. need to grow..
	    MessageDigest[] tempPool = new MessageDigest[hashPool.length+nextIncrement];
	    System.arraycopy(hashPool, 0, tempPool, 0, hashPool.length);
	    
	    for (int i=hashPool.length; i<tempPool.length; i++) {
		try {
		    tempPool[i] = MessageDigest.getInstance("MD5");
		}
		catch (NoSuchAlgorithmException e) {
		    System.out.println("We're screwed.. MD5 is not installed");
		    System.exit(1);
		}
		freeStack.push(i);
		reverseMap.put(hashPool[i], new Integer(i));
	    }
	    hashPool = tempPool;
	    nextIncrement = 2* nextIncrement;
	}
	
	return hashPool[freeStack.pop()];
    }

    public synchronized void freeHash(MessageDigest md) {
	// add the number back to the freeStack ..
	freeStack.push(((Integer)reverseMap.get(md)).intValue());
	

    }

    
    public static int MD5compare (byte left[] , byte right[]) {
	
	int i;

	for(i = 0; i < 16; i++) {
	    
	    if(left[i] < right[i]) {
		return -1;
	    } else if(left[i] > right[i]) {
		return 1;
	    }
	}

	return 0;
    }

    public static String MD5toString(byte bt[]) {
	StringBuffer sb = new StringBuffer(23); // 16 + 7 spaces..
	for (int i = 0; i < 15; i++) {
	     sb.append(byteToString(bt[i]));	
             sb.append(' ');
        }
	sb.append(byteToString(bt[15]));
	return sb.toString();


    }

    public static String byteToString(byte b) {
	return Integer.toHexString((b&0xFF));

    }
    
}
