#!/bin/bash

# See how we were called.
case "$1" in
    inr)
	echo "Starting INR..."
	xterm -T INR -geometry 80x25+0+25 -e java ins.inr.TwineResolver -rpc 15006 -udp 20006 -keyrouter 10006 --display &
	;;
    inrnd)
	echo "Starting INR..."
	xterm -T INR -geometry 80x25+0+25 -e java ins.inr.TwineResolver -rpc 15006 -udp 20006 -keyrouter 10006&
	;;
    inrnew)
	echo "Starting INR..."
	xterm -T INR_${HOSTNAME}:$2 -geometry 80x25+0+25 -e java ins.inr.TwineResolver -udp $2 -keyrouter $3 &
	;;
    ckr)
	echo "Starting CKR..."
	xterm -T CKR_${HOSTNAME}:10006 -geometry 80x25+0-25 -e ckr -j ${HOSTNAME}:10006 -p 10006 &
	;;
    ckrnew)
	echo "Starting CKR..."
	xterm -T CKR_${HOSTNAME}:$3 -geometry 80x25+0-25 -e ckr -j ${HOSTNAME}:$3 -p $2 &
	;;
    ckrbg)
	echo "Starting CKR in background..."
	nohup ckr -j ${HOSTNAME}:$3 -p $2 </dev/null >& /dev/null &
	;;
    test1)
	echo "Starting TwineTester 1..."
	xterm -T TwineTester1 -geometry 80x25-0+25 -e java tests.TwineTester -n ${HOSTNAME}:20006 '[k=a][x=y]'&
	;;
    test2)
	echo "Starting TwineTester 2..."
	xterm -T TwineTester2 -geometry 80x25-0+25 -e java tests.TwineTester -n ${HOSTNAME}:20006 '[l=b][w=z]'&
	;;
    test)
	echo "Starting TwineTester..."
	xterm -T TwineTester_$2_$3 -geometry 80x25-0+25 -e java tests.TwineTester -n $2 $3 &
	;;
    *)
	echo "Usage: you have to say what you want to start: inr, ckr, etc."
esac

exit 0
