#!/bin/sh

###############################################################
# This is a script that helps in certain types of experiments
# It inserts data into the network using the test.SearchCFS application
# Be careful because by default, SearchCFS doesn't refresh the data
# inserted, whereas resolvers use a very short soft-state.
# Author: Magdalena Balazinska
###############################################################

# We need the environment variable INR_HOME to set the classpath for all scripts
echo "Checking for INS_HOME"...
echo ${INS_HOME:?"Please set environment variable INS_HOME. See setclasspath.sh for more details"}

if [ $# -lt 3 ] 
then 
    echo ">>> Please specify: "
    echo "- the name of the file specifying the ports to use"
    echo "- the name of the file with the list of hosts and nb resolvers per host"
    echo "- the name of the file containing the list of files (with name-specifiers)"
    echo "  to insert"
else 

# Setting up variables
portsFile=$1 
hostsFile=$2
dataFile="$3"
listHosts=`awk '{ print $1 }' $hostsFile`
nbFilesToInsert=`awk '{ x++ } END { print x}' x=0 $dataFile`

firstport=`awk '{ if ($1=="FIRST_CKR_PORT") print $2 }' $portsFile`
RPC_OFFSET=`awk '{ if ($1=="RPC_PORT_OFFSET") print $2 }' $portsFile`
UDP_OFFSET=`awk '{ if ($1=="UDP_PORT_OFFSET") print $2 }' $portsFile`

MY_DIR=

# Inserting the data

let "i=1"
for host in $listHosts
do
    let "counter1=$firstport"
    nbResolvers=`awk '{ if ($1==target) print $2 }' target=$host $hostsFile`
    let "lastport=$firstport+$nbResolvers"

    while [  $counter1 -lt $lastport ]
    do
	if [ $i -gt $nbFilesToInsert ] 
	then
	    break 2
	fi

	# Get i th. name from file the file name must contain an absolute path
	file=`awk '{if (NR==line) print $0}' line=$i $dataFile`
	file=`eval echo $file`

	let "i = i+1"
	let "counter3 = counter1 + $UDP_OFFSET"
	eval echo 'ssh ${host} "${INS_HOME}/ins/scripts/experiments/insert-file-back.sh ${host} ${counter3} ${file}"'
	ssh ${host} "${INS_HOME}/ins/scripts/experiments/insert-file-back.sh ${host} ${counter3} ${file}"
	echo "Inserted file $file on ${host}:${counter3}"
	echo "Waiting for 1 minute to make sure all data gets processed"
	sleep 60 
	let "counter1 = counter1 + 1"
    done
    echo "Done ${host}..."
done

echo "All done."
    
fi
