/*
 *  This source file is copyright (C) 1999 by joeshmoe.com
 *  It may be freely used for non-commercial / development purposes.
 *  Commericial use requires the payment of a nominal license fee.
 *  Contact license@joeshmoe.com to purchase a license for commericial use.
 *
 *  It is requested that all users who modify this source code send their
 *  changes to joeshmoe.com
 * 
 *  Bugs reports / modifications can sent to bugs@joeshmoe.com.
 */

package joeshmoe.mpeg;

import java.util.Dictionary;
import java.util.Hashtable;
/**
 * This class provides a simple lookup interface to translate the genre 
 * field of an ID3 tag into a text string.  Reverse lookups can also 
 * be performed.
 **/
public class GenreLookup {
  static final String [] mGenres = {
    "Blues", 
    "Classic Rock",
    "Country",
    "Dance",
    "Disco",
    "Funk",
    "Grunge",
    "Hip-Hop", 
    "Jazz",
    "Metal",
    "New Age",
    "Oldies",
    "Other", 
    "Pop",
    "R&B",
    "Rap",
    "Reggae", 
    "Rock",
    "Techno",
    "Industrial",
    "Alternative", 
    "Ska",
    "Death Metal", 
    "Pranks",
    "Soundtrack",
    "Euro-Techno", 
    "Ambient",
    "Trip-Hop", 
    "Vocal",
    "Jazz+Funk", 
    "Fusion",
    "Trance",
    "Classical",
    "Instrumental", 
    "Acid",
    "House",
    "Game",
    "Sound Clip", 
    "Gospel",
    "Noise",
    "Alt. Rock", 
    "Bass",
    "Soul",
    "Punk",
    "Space",
    "Meditative",
    "Instrumental Pop",
    "Instrumental Rock", 
    "Ethnic",
    "Gothic",
    "Darkwave",
    "Techno-Industrial", 
    "Electronic", 
    "Pop-Folk",
    "Eurodance", 
    "Dream",
    "Southern Rock", 
    "Comedy", 
    "Cult",
    "Gangsta",
    "Top 40",
    "Christian Rap", 
    "Pop/Funk", 
    "Jungle",
    "Native American", 
    "Cabaret",
    "New Wave",
    "Psychadelic", 
    "Rave",
    "Showtunes", 
    "Trailer",
    "Lo-Fi",
    "Tribal",
    "Acid Punk",
    "Acid Jazz", 
    "Polka",
    "Retro",
    "Musical",
    "Rock & Roll", 
    "Hard Rock", 
    "Folk",
    "Folk/Rock",
    "National Folk", 
    "Swing",
    "Fusion",
    "Bebob",
    "Latin",
    "Revival",
    "Celtic",
    "Bluegrass",
    "Avantgarde",
    "Gothic Rock",
    "Progressive Rock",
    "Psychedelic Rock", 
    "Symphonic Rock", 
    "Slow Rock",
    "Big Band", 
    "Chorus",
    "Easy Listening", 
    "Acoustic", 
    "Humour",
    "Speech",
    "Chanson", 
    "Opera",
    "Chamber Music", 
    "Sonata",
    "Symphony",
    "Booty Bass", 
    "Primus",
    "Porn Groove", 
    "Satire",
    "Slow Jam", 
    "Club",
    "Tango",
    "Samba",
    "Folklore"};

  static Dictionary mGenreDict = null;

  /**
   * Finds the corresponding ID3 genre for the index number provided in pID
   * Returns null if the pID given is out of bounds (pID < 0 or pID > 127).
   **/
  public static String getGenreByID (int pID) {
    if (pID >= mGenres.length || pID < 0)
      return null;
    
    return mGenres[pID];
  }

  /**
   * Finds the correponding ID3 genre index number for the given genre name.
   * Returns null if the genre name provided cannot be found.
   * This function will take longer to return the first time it is run
   * as a Hashtable needs to be initialized.
   **/
  public static int getIDByGenre (String pGenre) {

    if (mGenreDict == null) {
      // load the hashtable

      mGenreDict = new Hashtable (mGenres.length + 10);
      
      for (int i = 0; i  < mGenres.length; i++)
	mGenreDict.put (mGenres[i], new Integer (i));
    }

    Integer id =  (Integer) mGenreDict.get (pGenre);

    if (id == null)
      return -1;
    else 
      return id.intValue();
  }
      
}
