/*
 *  This source file is copyright (C) 1999 by joeshmoe.com
 *  It may be freely used for non-commercial / development purposes.
 *  Commericial use requires the payment of a nominal license fee.
 *  Contact license@joeshmoe.com to purchase a license for commericial use.
 *
 *  It is requested that all users who modify this source code send their
 *  changes to joeshmoe.com
 * 
 *  Bugs reports / modifications can sent to bugs@joeshmoe.com.
 */

package joeshmoe.mpeg;

/**
 * This class represents an ID3 tag.  This tag, appended to the end of an 
 * MPEG audio file, gives information about the contents of the file.  
 * All fields are automatically (and silently) truncated to their
 * maximum lengh.
 **/
public class ID3Tag {
  
    String mArtist = "";
    /** 
     * returns the value of the artist name field
     **/
    public String getArtist () {
	return mArtist;
    }
    /**
     * sets the value of the artist name field.  max length: 30 characters
     **/
    public void setArtist (String pArtist) {
	if (pArtist.length() > 30)
	    pArtist = pArtist.substring (0, 30);

	mArtist = pArtist;
    }

    /**
     * returns the value of the song title field
     **/
    String mSong = "";
    public String getSong () {
	return mSong;
    }
    /**
     * sets the value of the song title field.  max length: 30 characters
     **/
    public void setSong (String pSong) {
	if (pSong.length() > 30)
	    pSong = pSong.substring (0, 30);

	mSong = pSong;
    }

    String mAlbum = "";
    /**
     * returns the value of the album title field
     **/
    public String getAlbum () {
	return mAlbum;
    }
    /**
     * sets the value of the album title field.  max length: 30 characters
     **/
    public void setAlbum (String pAlbum) {
	if (pAlbum.length() > 30)
	    pAlbum = pAlbum.substring (0, 30);

	mAlbum = pAlbum;
    }

    private String mYear = "";
    /**
     * returns the value of the year of release field.
     **/
    public String getYear () {
	return mYear;
    } 
    /**
     * sets the value of the year of release field.  max length: 4 characters
     **/
    public void setYear (String pYear) {
	if (pYear.length() > 4)
	    pYear = pYear.substring (0, 4);

	mYear = pYear;
    }

    String mComment = "";
    /**
     * returns the value of the comment field
     **/
    public String getComment () {
	return mComment;
    }
    /** 
     * sets the value of the comment field.  max length: 30 characters
     **/
    public void setComment (String pComment) {
	if (pComment.length() > 30)
	    pComment = pComment.substring (0, 30);

	mComment = pComment;
    }

    int mGenreID;
    /** 
     * returns the value of the genre id field
     * @see GenreLookup
     **/
    public int getGenreID () {
	return mGenreID;
    }
    /**
     * sets the value of the genre id field.  max value: 255
     * @see GenreLookup
     **/
    public void setGenreID (int pGenreID) {
	if (pGenreID > 255)
	    pGenreID = 255;
	mGenreID = pGenreID;
    }
}
