dnl $Id: acinclude.m4,v 1.10 2002/08/30 22:58:58 snoeren Exp $


dnl DM's macro to find OpenSSL

AC_DEFUN(SFS_OPENSSL,
[AC_SUBST(OPENSSL_DIR)
AC_ARG_WITH(openssl,
	[  --with-openssl[=DIR]    use OpenSSL libraries [default=/usr]])

AC_MSG_CHECKING([for OpenSSL])
test "$with_openssl" = "yes" && unset with_openssl
unset OPENSSL_DIR
if test -z "$with_openssl"; then
    with_openssl=no
    for dir in /usr /usr/local/openssl/ /usr/local/ssl/ \
                `ls -1d /usr/local/openssl-*/ 2>/dev/null | tail -1`; do
        if test -f $dir/lib/libssl.a -a -f $dir/include/openssl/ssl.h; then
            with_openssl=`echo $dir | sed -e 's/\/$//'`
            break
        fi
    done
fi
OPENSSL_DIR="$with_openssl"
AC_MSG_RESULT([$with_openssl])
if test "$with_openssl" = no; then
    unset OPENSSL_DIR
else
   AC_DEFINE(HAVE_LIBSSL)
   SSL_LIBS="-L$OPENSSL_DIR -lcrypto"
   AC_SUBST(SSL_LIBS)
   IPKGS="$IPKGS, libssl0.9.6"
   AC_CHECK_LIB(crypto, EVP_CIPHER_CTX_set_key_length, AC_DEFINE(MODERN_SSL))
fi])


dnl
dnl Use dmalloc if requested (from DM)
dnl
dnl No path searching because this is only for developers.
dnl
AC_DEFUN(SFS_DMALLOC,
[
dnl AC_ARG_WITH(small-limits,
dnl --with-small-limits       Try to trigger memory allocation bugs,
dnl CPPFLAGS="$CPPFLAGS -DSMALL_LIMITS"
dnl test "${with_dmalloc+set}" = set || with_dmalloc=yes
dnl )
AC_CHECK_HEADERS(memory.h)
AC_ARG_WITH(dmalloc,
[  --with-dmalloc          use debugging malloc from ftp.dmalloc.com
                          (set MAX_FILE_LEN to 1024 when installing)],
pref=$prefix
test "$pref" = NONE && pref=$ac_default_prefix
test "$withval" = yes && withval="${pref}"
test "$withval" || withval="${pref}"
using_dmalloc=no
if test "$withval" != no; then
        AC_DEFINE(DMALLOC, 1, Define if compiling with dmalloc. )
        CPPFLAGS="$CPPFLAGS -DUSING_DMALLOC"
        CPPFLAGS="$CPPFLAGS -I${withval}/include"
        LIBS="$LIBS -L${withval}/lib -ldmalloc"
	echo "Enabling dmalloc support."
        using_dmalloc=yes
fi)
AM_CONDITIONAL(DMALLOC, test "$using_dmalloc" = yes)
])


dnl JS's macro to find Tesla

AC_DEFUN(JS_TESLA,
[AC_ARG_WITH(tesla,
	[  --with-tesla[=DIR]      use TESLA [default=/usr/local]])

AC_MSG_CHECKING([for Tesla])
test "$with_tesla" = "yes" && unset with_tesla
if test -z "$with_tesla"; then
    with_tesla=no
    for dir in /usr/local; do
        if test -f $dir/include/tesla/tesla.h -a -f $dir/sbin/tesla-rebuild ;then
            with_tesla=`echo $dir | sed -e 's/\/$//'`
            break
        fi
    done
fi

AC_MSG_RESULT([$with_tesla])
if test "$with_tesla" = "no"; then
    AC_MSG_ERROR([unable to find Tesla (need includes and tesla-rebuild)])
else
    TESLA_DIR="$with_tesla"
    AC_SUBST(TESLA_DIR)
    TESLA_INCLUDES="-I$with_tesla/include"
    AC_SUBST(TESLA_INCLUDES)
    TESLA_REBUILD="$with_tesla/sbin/tesla-rebuild"
    AC_SUBST(TESLA_REBUILD)
fi])

dnl JS's macro to find Tcl

AC_DEFUN(JS_TCL,
[
AC_ARG_WITH(tcl,
	[  --with-tcl              use Tcl [default=yes]],
	:, with_tcl=yes)

if test "$with_tcl" != no; then
    AC_MSG_CHECKING([for Tcl libraries])
    for dir in /usr/lib /usr/local/lib; do
        for file in tcl tcl8.3 tcl8.2; do
            if test -f $dir/lib$file.a -o -f $dir/lib$file.so; then
                TCL_LIBS="-L$dir -l$file -lm"
                break 2
            fi
        done
    done
    if test -z "$TCL_LIBS"; then
        with_tcl=no
        AC_MSG_RESULT([no])
    else
        AC_MSG_RESULT([$TCL_LIBS])
    fi
fi

if test "$with_tcl" != no; then
    AC_MSG_CHECKING([for Tcl includes])
    for dir in /usr/include /usr/local/include; do
        for subdir in "" /tcl /tcl8.3 /tcl8.2; do
            if test -f $dir$subdir/tcl.h; then
                TCL_INCLUDES="-I$dir$subdir"
                break 2
            fi
        done
    done
    if test -z "$TCL_INCLUDES"; then
        with_tcl=no
        AC_MSG_RESULT([no])
    else
        AC_MSG_RESULT([$TCL_INCLUDES])
        AC_DEFINE(HAVE_TCL)
        IPKGS="$IPKGS, tcl"
    fi
fi

#if test -z "$HAVE_TCL"; then
#    unset TCL_LIBS
#    unset TCL_INCLUDES
#fi

AC_SUBST(TCL_LIBS)
AC_SUBST(TCL_INCLUDES)
])

