/*
 * Migrate Session Layer
 *
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: daemon.hh,v 1.9 2002/10/10 21:45:14 snoeren Exp $
 *
 * Migrate daemon TESLA wrapper.
 *
 */

#ifndef HH_DAEMON
#define HH_DAEMON

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
#ifdef HAVE_SYS_UN_H
# include <sys/un.h>
#endif

#include <set>

#include <tesla/client.hh>
#include <tesla/flow_handler.hh>
#include <migrate.h>

// TeslaMaster's set of clients

extern set<client*> clients;

// Structures for daemon communcation

typedef enum { SESSION_MSG,
	       CONNECTION_MSG,
	       CONNREBIND_MSG,
	       SESSION_EST,
	       SESSION_MIGRATE,
	       SESSION_RESUME_REQUEST,
	       SESSION_RESUME_CHALLENGE,
	       SESSION_RESUME_RESPONSE,
	       MONITOR_STATE_CHANGE,
	       MONITOR_IF_STATE_CHANGE,
	       CONT_MSG,
	       COMPCONT_MSG,
               FD_MSG,
               LAST_MSG_TYPE } mmsgtype; 

typedef struct {
  mmsgtype  type;
  pid_t     pid;
  int       len;
} mmsghdr;


// Migrate daemon class

class Daemon : public client {

public:

  Daemon(int _daemonfd) : client(_daemonfd) {

    char *pipefmt = "/tmp/.migratepipe-%d";
    char  pipename[256];
    char *envport = getenv(ENV_MIGRATE_PORT);
    int   mport = MIGPORT;
    struct sockaddr_un uaddr;
    
    // Extract migrate port from the environment
    if (envport) {
      char *end;
      long newport = strtol(envport, &end, 0);
      if (*end || newport < 1 || newport > 65535) {
	ts_error("Invalid port \"%s\" in MIGRATE_PORT\n", envport);
      } else {
	mport = newport;
      }
    }
    sprintf(pipename, pipefmt, mport);

    // Contact daemon over UNIX socket
    memset(&uaddr, 0, sizeof(uaddr));
    uaddr.sun_family = AF_UNIX;
    strcpy(uaddr.sun_path,pipename);
    if (::connect(_daemonfd, (struct sockaddr *) &uaddr,
		  sizeof(uaddr)) < 0) {
      ts_error("Unable to contact local daemon: %s", strerror(errno));
      set_ractive(false);
      ::close(_daemonfd);
      fd = -1;
      return;
    }
    ::clients.insert(this);
    
    // Tell daemon I'm not important
    set_inessential(true);
  }

  // Remove ourselves from the clients list upon destruction
  ~Daemon() { ::clients.erase(this); }

  bool is_present() { return (fd != -1); }

  virtual void ravail();

  // Old-style functions to be ported
  int sendto(mmsgtype msgtype, int pid, const char *buf, unsigned int buflen);

  // XXX: Hack
  int getfd() { return fd; }
};

#endif

