/*
 * Migrate Session Layer
 *
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: migrate_handler_udp.hh,v 1.8 2002/10/02 22:10:32 snoeren Exp $
 *
 * Migrate API implementation.
 *
 */

#ifndef HH_MIGRATE_HANDLER_UDP
#define HH_MIGRATE_HANDLER_UDP

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif

#include "migrate_handler.hh"

class migrate_handler_udp : public migrate_handler {

private:

  hash_map<const char *, MigrateConnection *, hash<const char *> > addr_conns;
  hash_map<int, MigrateConnection *, hash<int> > handler_conns;

  enum {
    NOT,
    TIGHT,
    OPEN
  }  _connected;

public:

  migrate_handler_udp(init_context& ctxt) : migrate_handler(ctxt),
					    _connected(NOT) {}
  ~migrate_handler_udp()
  {
    hash_map<const char *, MigrateConnection *,
      hash<const char *> >::iterator i;
    for(i = addr_conns.begin() ; i != addr_conns.end(); i++) {
      if (migrate_daemon->is_present()) {
	migrate_daemon->sendto(CONNECTION_MSG, (int)getpid(),
			       (const char *)getOldConn(-1, (*i).second),
			       sizeof(migrate_connection));
      }
      delete (*i).second;
    }
    addr_conns.clear();
  }

  virtual int connect(address a);
  virtual void connected(flow_handler *from, bool success);
  virtual bool avail(flow_handler *from, data d);
  virtual int write(data d);

  virtual void changeSession(MigrateSession *newSession,
			     const migrate_connection *conn);
  virtual void migrateConn(int fd, MigrateSession *session);

protected:

  virtual void updateConns();

private:

  MigrateConnection * initUDPSession(address a);

  DECLARE_HANDLER
};

#endif
