/*
 * Migrate Session Layer
 *
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 * 
 * $Id: migrate_internal.h,v 1.29 2002/10/10 21:50:21 snoeren Exp $
 *
 * Include file for use by the Migrate library itself.
 *
 */

#ifndef _MIGRATE_INTERNAL_H
#define _MIGRATE_INTERNAL_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <setjmp.h>

#ifdef USE_DMALLOC
# include <dmalloc.h>
#endif

#include <tesla/tesla.h>
#include <migrate.h>

#define DBFILENAME "/tmp/migdb-%d-%d"

#define MIGRATE_FATAL(e)  do {                                      \
        fprintf(stderr, "%s in %s() at %s:%d\n", e, __FUNCTION__,   \
                __FILE__, __LINE__);                                \
        exit(1);             } while (0)

#define MIGRATE_PROTECT(fd) do {                                         \
        if((fd >= 0) && (fd < FD_SETSIZE) &&                             \
           (FD_ISSET(fd, &privfds) || (fd == daemonfd))) {               \
          errno = EBADF;                                                 \
          return -1;                                                     \
	}                      } while(0)

extern int daemonfd;

typedef enum { SESSION_MSG,
	       CONNECTION_MSG,
	       CONNREBIND_MSG,
	       SESSION_EST,
	       SESSION_MIGRATE,
	       SESSION_RESUME_REQUEST,
	       SESSION_RESUME_CHALLENGE,
	       SESSION_RESUME_RESPONSE,
	       MONITOR_STATE_CHANGE,
	       MONITOR_IF_STATE_CHANGE,
	       CONT_MSG,
	       COMPCONT_MSG,
               FD_MSG,
               LAST_MSG_TYPE } mmsgtype; 

typedef struct {
  mmsgtype  type;
  pid_t     pid;
  int       len;
} mmsghdr;

struct fdhandle {
  int              fd;
  char            *buff;
  int              buflen;
  struct fdhandle *next;
};

#endif /* _MIGRATE_INTERNAL_H */
