
/*
 * Migrate Session Layer: Monitoring Daemon
 *
 * Jon Salz <jsalz@mit.edu>
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: iflist.c,v 1.7 2001/11/19 19:22:18 jsalz Exp $
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#ifdef HAVE_STDIO_H
#  include <stdio.h>
#endif

#ifdef STDC_HEADERS
#  include <stdlib.h>
#  include <string.h>
#endif

#ifdef HAVE_SYS_IOCTL_H
#  include <sys/ioctl.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#  include <sys/types.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
#  include <sys/socket.h>
#endif

#ifdef HAVE_NETINET_IN_H
#  include <netinet/in.h>
#endif

#ifdef HAVE_NET_IF_H
#  include <net/if.h>
#endif

#ifdef HAVE_ARPA_INET_H
#  include <arpa/inet.h>
#endif

static int opt_repeated = 0;

void usage(char *prog)
{
    fprintf(stderr,
	    "Usage: %s [-h] [-r]\n"
	    "\n"
	    "  -h: print this message\n"
	    "  -r: run repeatedly (once per line of input;\n"
            "      output terminated by empty line)\n",
	    prog);
    exit(1);
}

int main(int argc, char **argv)
{
    struct ifconf ifc;
    struct ifreq *ifr;
    int numreqs = 10;
    int skfd;
    int i;
#ifdef GNU_LINUX
    int n;
#endif

    for (i = 1; i < argc; ++i)
    {
	if (!strcmp(argv[i], "-r"))
	    opt_repeated = 1;
	else
	    usage(argv[0]);
    }

    if ((skfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
    {
	perror("socket");
	exit(1);
    }

    ifc.ifc_buf = NULL;
    numreqs = 0;

    for (;;)
    {
	if (opt_repeated)
	{
	    int ch = getchar();
	    if (ch == EOF)
		break;
	    if (ch != '\n')
		continue;
	}

	ifc.ifc_len = sizeof(struct ifreq) * numreqs;

	while (1)
	{
	    if (ifc.ifc_buf)
	    {
		if (ioctl(skfd, SIOCGIFCONF, &ifc) < 0)
		{
		    perror("SIOCGIFCONF");
		    exit(1);
		}

		if (ifc.ifc_len < sizeof(struct ifreq) * numreqs)
		    break;
	    }

#ifdef GNU_LINUX
	    numreqs += 10;
#else
	    /* Seems we only get one shot under BSD, so let's make it */
	    /* really big. */
	    numreqs += 100;
#endif
	    ifc.ifc_len = sizeof(struct ifreq) * numreqs;
	    ifc.ifc_buf = realloc(ifc.ifc_buf, ifc.ifc_len);
	}
    
	ifr = ifc.ifc_req;

#ifdef GNU_LINUX
	for (n = 0; n < ifc.ifc_len; n += sizeof(struct ifreq), ++ifr)
#else
#define max(a,b) ((a)>(b) ? (a) : (b))
#define size(p)	max((p).sa_len, sizeof(p))
	for (; (char*)(ifr) < ((char*)ifc.ifc_buf) + ifc.ifc_len;
	     ifr = (void*)( ((char*)ifr) + sizeof(ifr->ifr_name) + size(ifr->ifr_addr)) )
#endif
	{
	    struct sockaddr_in *sin = (struct sockaddr_in *)(&ifr->ifr_addr);
	    struct ifreq ifr2, ifr3;

	    strcpy(ifr2.ifr_name, ifr->ifr_name);
	    strcpy(ifr3.ifr_name, ifr->ifr_name);

	    if (ioctl(skfd, SIOCGIFFLAGS, &ifr2) < 0 ||
		ioctl(skfd, SIOCGIFNETMASK, &ifr3) < 0)
	    {
		continue;
	    }

	    if (!sin->sin_addr.s_addr || ifr->ifr_addr.sa_family != AF_INET)
		continue;
	    
#ifdef GNU_LINUX
# define NETMASK_FIELD ifr_netmask
#else
# define NETMASK_FIELD ifr_addr
#endif

	    printf("interface %s %s ",
		   ifr->ifr_name,
		   inet_ntoa(sin->sin_addr));
	    printf("%s %s\n",
		   inet_ntoa(((struct sockaddr_in *)(&ifr3.NETMASK_FIELD))->sin_addr),
		   (ifr2.ifr_flags & IFF_UP) ? "up" : "down");
	}

	if (!opt_repeated)
	    break;

	printf("\n");
	fflush(stdout);
    }

    return 0;
}
