#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#endif

#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_SYS_SELECT_h
# include <sys/select.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif
#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif  
int
main(int argc, char *argv[] )
{
    int s, n;
    struct sockaddr_in sin;
    struct hostent     *he;
  
    char buf[1024];
    fd_set rfds;
  
    if (argc != 2) {
      printf ("no args\n");
      exit (1);
    }
  
    if ( (s = socket (PF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0 ) {
      perror ("socket");
      exit (-1);
    }
  
    if ((n = fcntl (s, F_GETFL)) < 0
        || fcntl (s, F_SETFL, n | O_NONBLOCK) < 0) {
      perror ("O_NONBLOCK");
      exit (-1);
    }  
  
    if ( (he = gethostbyname (argv[1])) == NULL) {
      perror ("gethostbyname");
      exit (-1);
    }
    
    sin.sin_addr = *(struct in_addr *) he->h_addr;
    sin.sin_family = AF_INET;
    sin.sin_port = htons (6353);
   
    n = connect (s, (struct sockaddr *)&sin, sizeof(sin));
    if ( n < 0 &&
         errno != EINPROGRESS ) {
      perror ("connect");
      exit (-1);
    }
   
    while (1) {
      FD_ZERO (&rfds);
      FD_SET (s, &rfds);
      if ((n = select (s + 1, &rfds, NULL, NULL, NULL)) < 0) {
        perror ("select");
        exit (-1);
      } else if (n > 0) {
        n = read (s, buf, 1023);
        if (n < 0) {
        perror ("read");
        exit (0);
        } else if (n > 0) {
        buf[n] = '\0';
        printf ("read %d bytes: \"%s\"\n", n, buf);
        } else { /* n == 0 */
        printf ("got EOF\n");
        exit (0);
        }
      }
    }
}
