#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#endif

#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif
#ifdef HAVE_SYS_SELECT_h
# include <sys/select.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
#ifdef HAVE_TIME_H
# include <time.h>
#endif
#ifdef HAVE_SIGNAL_H
# include <signal.h>
#endif
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif

  char buf[] = "data";
  
int
main(int   argc, char *argv[] )
{
    struct sockaddr_in sin;
    struct sockaddr saddr;
    int sl, slen, n, sc =0;
    fd_set rfds, wfds;
  
    if ( (sl = socket (PF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0 ) {
      perror ("socket");
      exit (-1);
    }
  
    n = 1;
    if (setsockopt (sl, SOL_SOCKET, SO_REUSEADDR, (char *)&n, sizeof
(n)) < 0) {
      perror ("SO_REUSEADDR");
      exit (-1);
    }
  
    if ((n = fcntl (sl, F_GETFL)) < 0
        || fcntl (sl, F_SETFL, n | O_NONBLOCK) < 0) {
      perror ("O_NONBLOCK");
      exit (-1);
    }  
  
    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = INADDR_ANY;
    sin.sin_port = htons (6353);
    if ( bind (sl, (struct sockaddr *) &sin, sizeof (sin)) < 0 ) {
      perror ("socket");
      exit (-1);
    }
    
    if (listen (sl, 1) < 0) {
      perror ("listen");
      exit (-1);
    }
  
    FD_ZERO (&rfds);
    FD_SET (sl, &rfds);
    if ((n = select (sl + 1, &rfds, NULL, NULL, NULL)) < 0) {
      if (n < 0) {
        perror ("select");
        exit (-1);
      }
    }
    
    if ((sc = accept (sl, &saddr, &slen)) < 0) {
      perror ("accept");
      exit (-1);
    }
  
    FD_ZERO (&wfds);
    FD_SET (sc, &wfds);
    if ((n = select (sc + 1, NULL, &wfds, NULL, NULL)) < 0) {
      perror ("select");
      exit (-1);
    } else if (n > 0) {
      n = write (sc, buf, strlen(buf));
      if (n < 0 )
        perror ("write");
      else {
        printf ("wrote %d bytes: %s\n", n, buf);
      }
      exit (0);
    }
    
    return(0);
}
