#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif
#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif
#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#include <migrate.h>

static migrate_continuation *
mobhandler(migrate_session *session, int flags)
{
  fprintf(stderr, "Received mobility update: %s | %s\n",
	  ((flags & M_LOCAL) ? "M_LOCAL" : "M_REMOTE"),
	  ((flags & M_INSTANT) ? "M_INSTANT" : ""));

  return NULL;
}

int
main(int argc, char *argv[])
{
  struct hostent *hostptr;
  struct sockaddr_in addr;
  int sock, res;
  socklen_t len;
  char ch;
  size_t bufsize;
#if 0
  pid_t pid;
#endif
  migrate_session * session = NULL;

  if(argc!=3) {
    fprintf(stderr, "Need hostname and port\n");
    exit(1);
  }

  sock = socket(AF_INET, SOCK_STREAM, 0); 

  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_RCVBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket rcv buffer size: %d\n", bufsize);
  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_SNDBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket snd buffer size: %d\n", bufsize);


  /* Open network listening socket */
  memset(&addr, 0, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = INADDR_ANY;
  addr.sin_port = 0;

  /* bind(sock, (struct sockaddr *)&addr, sizeof(addr)); */

  if ((hostptr = gethostbyname(argv[1]))==NULL) {
    fprintf(stderr, "Unknown host %s.\n", argv[1]);
    exit(1);
  }
  
  /* Open network listening socket */
  memset(&addr, 0, sizeof(addr));
  addr.sin_family = hostptr->h_addrtype;
  memcpy(&addr.sin_addr, hostptr->h_addr, hostptr->h_length);
  addr.sin_port = htons(atoi(argv[2]));

  if(migrate_avail()) {
    char hn[255];
    migrate_lookupfunc lf;
    lf.func = gethostbyname;
    lf.arg = argv[1];
    if(!(session = migrate_session_create(sock, M_AUTOCLOSE))) {
      fprintf(stderr, "migrate_session_create failed: %s\n",
	      strerror(errno));
      exit(1);
    }
    if(migrate_set_lookupfunc(session, &lf)) {
      fprintf(stderr, "set_lookupfunc failed: %s\n", strerror(errno));
      exit(1);
    }
    gethostname(hn, 255);
    lf.arg = hn;
    if(migrate_set_lookupname(session, &lf)) {
      fprintf(stderr, "set_lookupname failed with %s: %s\n", hn, strerror(errno));
      exit(1);
    }
    if(migrate_register_handler(session, mobhandler)) {
      fprintf(stderr, "register_handler failed: %s\n", strerror(errno));
      exit(1);
    }
  } else {
    printf("Can't find Migrate handler\n");
  }

  printf("Trying to connect to port %d (%s)...\n", atoi(argv[2]),
	 argv[1]);
  if(connect(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
    printf("connect: %s\n", strerror(errno));
    exit(1);
  }
  getpeername(sock, (struct sockaddr *)&addr, &len);
  getsockopt(sock, SOL_SOCKET, SO_SNDBUF, &bufsize, &len);
  printf("Connected to %s:%hu with %d\n", inet_ntoa(addr.sin_addr),
	 ntohs(addr.sin_port), bufsize);

  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_RCVBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket rcv buffer size: %d\n", bufsize);
  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_SNDBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket snd buffer size: %d\n", bufsize);

#if 0
  if ((pid = fork())) {
    fprintf(stderr, "Forked child %d, we're done.\n", pid);
    close(sock);
    wait(NULL);
    exit(0);
  }
#endif


  while(read(0, &ch, 1) == 1) {
    res = write(sock, &ch, 1);
    if (res == -1) {
      fprintf(stderr, "write: %s\n", strerror(errno));
      exit(-1);
    }
  }

  if(migrate_avail())
    if(migrate_session_close(session))
      fprintf(stderr, "Migrate close: %s\n", strerror(errno));
  if(close(sock))
    fprintf(stderr, "close: %s\n", strerror(errno));

  printf("Hit any key to exit...\n");
  getchar();

  return 0;
}





