/* Test multiple connections in one session */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif
#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif
#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#include <migrate.h>

int
main(int argc, char *argv[])
{
  struct hostent *hostptr;
  struct sockaddr_in addr;
  int sock, sock2, res;
  socklen_t len;
  char ch;
  size_t bufsize;
#if 1
  pid_t pid;
#endif
  migrate_session * session;

  if(argc!=3) {
    fprintf(stderr, "Need hostname and port\n");
    exit(1);
  }

  sock = socket(AF_INET, SOCK_STREAM, 0); 

  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_RCVBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket rcv buffer size: %d\n", bufsize);
  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_SNDBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket snd buffer size: %d\n", bufsize);

  sock2 = socket(AF_INET, SOCK_STREAM, 0); 

  len = sizeof(bufsize);
  if (getsockopt(sock2, SOL_SOCKET, SO_RCVBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock2);
    exit(1);
  }
  printf("Socket2 rcv buffer size: %d\n", bufsize);
  len = sizeof(bufsize);
  if (getsockopt(sock2, SOL_SOCKET, SO_SNDBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock2);
    exit(1);
  }
  printf("Socket2 snd buffer size: %d\n", bufsize);


  if ((hostptr = gethostbyname(argv[1]))==NULL) {
    fprintf(stderr, "Unknown host %s.\n", argv[1]);
    exit(1);
  }
  
  /* Open network listening socket */
  memset(&addr, 0, sizeof(addr));
  addr.sin_family = hostptr->h_addrtype;
  memcpy(&addr.sin_addr, hostptr->h_addr, hostptr->h_length);
  addr.sin_port = htons(atoi(argv[2]));

  if(migrate_avail()) {
    char hn[255];
    migrate_lookupfunc lf;
    lf.func = gethostbyname;
    lf.arg = argv[1];
    fprintf(stderr, "here...\n");
    if(!(session = migrate_session_create(sock, M_AUTOCLOSE))) {
      fprintf(stderr, "migrate_session_create failed: %s\n",
	      strerror(errno));
      exit(1);
    }
    fprintf(stderr, "here...\n");
    if(migrate_set_lookupfunc(session, &lf)) {
      fprintf(stderr, "set_lookupfunc failed\n");
      exit(1);
    }
    gethostname(hn, 255);
    lf.arg = hn;
    if(migrate_set_lookupname(session, &lf)) {
      fprintf(stderr, "set_lookupname failed with %s: %s\n", hn, strerror(errno));
      exit(1);
    }
    if(migrate_add_connection(sock2, session)) {
      fprintf(stderr, "add_connection failed: %s", strerror(errno));
      exit(1);
    }
  } else {
    printf("Can't find Migrate handler\n");
  }

  printf("Trying to connect to port %d (%s)...\n", atoi(argv[2]),
	 argv[1]);
  if(connect(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
    printf("connect: %s\n", strerror(errno));
  }
  getpeername(sock, (struct sockaddr *)&addr, &len);
  getsockopt(sock, SOL_SOCKET, SO_SNDBUF, &bufsize, &len);
  printf("Connected to %s:%hu with %d\n", inet_ntoa(addr.sin_addr),
	 ntohs(addr.sin_port), bufsize);

  /* Open network listening socket */
  memset(&addr, 0, sizeof(addr));
  addr.sin_family = hostptr->h_addrtype;
  memcpy(&addr.sin_addr, hostptr->h_addr, hostptr->h_length);
  addr.sin_port = htons(atoi(argv[2])+1);

  len = sizeof(addr);

  sleep(1);
  printf("Trying to connect to port %d (%s)...\n", atoi(argv[2])+1,
	 argv[1]);
  if(connect(sock2, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
    printf("connect: %s\n", strerror(errno));
  }
  getpeername(sock2, (struct sockaddr *)&addr, &len);
  getsockopt(sock2, SOL_SOCKET, SO_SNDBUF, &bufsize, &len);
  printf("Connected to %s:%hu with %d\n", inet_ntoa(addr.sin_addr),
	 ntohs(addr.sin_port), bufsize);

  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_RCVBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket rcv buffer size: %d\n", bufsize);
  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_SNDBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket snd buffer size: %d\n", bufsize);

#if 1
  if ((pid = fork())) {
    fprintf(stderr, "Forked child %d, we're done.\n", pid);
    close(sock);
    wait(NULL);
    exit(0);
  }
#endif

  again:
    while((res = read(0, &ch, 1)) == 1)
      write(sock, &ch, 1);
    if (res == -1) {
      fprintf(stderr, "read: %s\n", strerror(errno));
      goto again;
    }
    close(sock);
    close(sock2);
    printf("Hit any key to exit...\n");
    getchar();

  return 0;
}





