#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif
#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif

#include <migrate.h>

int
main(int argc, char *argv[])
{
  struct sockaddr_in addr;
  int sock, sock2, newsock, newsock2;
  socklen_t len = sizeof(addr);
  int port;
  char c;
  int retval, res = 0;
  fd_set fds;
  int bufsize;

  if(argc!=2) {
    fprintf(stderr, "Need port\n");
    exit(1);
  }

  port = atoi(argv[1]);

  sock = socket(AF_INET, SOCK_STREAM, 0); 
  sock2 = socket(AF_INET, SOCK_STREAM, 0); 

  /* Open network listening socket */
  memset(&addr, 0, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = INADDR_ANY;
  addr.sin_port = htons(port);

  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_RCVBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket rcv buffer size: %d\n", bufsize);
  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_SNDBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket snd buffer size: %d\n", bufsize);

  if(bind(sock, (struct sockaddr *)&addr, sizeof(addr))) {
    printf("bind: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }

  addr.sin_port = htons(port+1);
  if(bind(sock2, (struct sockaddr *)&addr, sizeof(addr))) {
    printf("bind: %s\n", strerror(errno));
    close(sock2);
    exit(1);
  }

  
  printf("Listening on port %hu...\n", port);
  if(listen(sock, 0)) {
    printf("listen: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }

  printf("Accepting connection\n");
  len = sizeof(addr);
  newsock = accept(sock, (struct sockaddr *)&addr, &len);
  if(newsock < 0) {
    fprintf(stderr, "Accept: %s\n", strerror(errno));
    exit(1);
  }
  printf("Connected to %s:%hu\n", inet_ntoa(addr.sin_addr),
	 ntohs(addr.sin_port));

  len = sizeof(bufsize);
  if (getsockopt(newsock, SOL_SOCKET, SO_RCVBUF, &bufsize, &len)) {
    printf("bind: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket rcv buffer size: %d\n", bufsize);
  len = sizeof(bufsize);
  if (getsockopt(newsock, SOL_SOCKET, SO_SNDBUF, &bufsize, &len)) {
    printf("bind: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket snd buffer size: %d\n", bufsize);

  printf("Listening on port %hu...\n", port+1);
  if(listen(sock2, 0)) {
    printf("listen: %s\n", strerror(errno));
    close(sock2);
    exit(1);
  }
  printf("Accepting connection\n");
  len = sizeof(addr);
  newsock2 = accept(sock2, (struct sockaddr *)&addr, &len);
  if(newsock2 < 0) {
    fprintf(stderr, "Accept: %s\n", strerror(errno));
    exit(1);
  }
  printf("Connected to %s:%hu\n", inet_ntoa(addr.sin_addr),
	 ntohs(addr.sin_port));

#if 0
  if(migrate_avail()) {
    if(!(session = migrate_get_session(newsock))) {
      fprintf(stderr, "Can't get Migrate session; %s", strerror(errno));
      exit(1);
    }
    if(migrate_add_connection(newsock2, session)) {
      fprintf(stderr, "Can't add connection: %s", strerror(errno));
      exit(1);
    }
  }
#endif

  fgetc(stdin);
  printf("We'll die when the connection does.\n");

  FD_ZERO(&fds);
  FD_SET(newsock, &fds);
  while((retval = select(newsock + 1, &fds, NULL, NULL, NULL)) > 0){
    res = read(newsock, &c, 1);
    if (res < 0)
      printf("Read: %s\n", strerror(errno));    
    else if (!res) {
      fprintf(stderr, "Read returned EOF, exiting...\n");
      break;
    } else {
      printf("%c", c);
      fflush(stdout);
    }
  }
  if (retval < 0)
    fprintf(stderr, "serv select: %s\n", strerror(errno));

  close(sock);
  close(sock2);
  close(newsock);
  close(newsock2);
  return 0;
}
