
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <errno.h>
#include <stdio.h>
#include <sys/wait.h>

#include <migrate.h>
#include <tesla/tesla.h>

int
main(int argc, char *argv[])
{
    char ch;
    int sock = atoi(argv[1]);
    int i;
    migrate_session *session = NULL;
   
    ts_restore_state("state.out");

    if(!(session = migrate_get_session(sock))) {
      fprintf(stderr, "Unable to find session for fd %d\n", sock);
      exit(-1);
    }

    MIGRATE_RESTORE(session, i);
    fprintf(stderr, "Retrieved value of i is %d\n", i);

    while (read(sock, &ch, 1) == 1) {
	putchar(ch);
    }

    printf("Done!\n");

    return 0;
}
