
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <errno.h>
#include <stdio.h>
#include <sys/wait.h>

#include <migrate.h>
#include <tesla/tesla.h>

static void
mobcont(migrate_session *session)
{
  fprintf(stderr, "The continuation was called!\n");
}

static migrate_continuation *
mobhandler(migrate_session *session, int flags)
{
  static migrate_continuation cont;
  static fd_set fds;

  fprintf(stderr, "Received mobility update: %s | %s\n",
	  ((flags & M_LOCAL) ? "M_LOCAL" : "M_REMOTE"),
	  ((flags & M_INSTANT) ? "M_INSTANT" : ""));
  
  memset(&cont, 0, sizeof(cont));
  cont.cont = mobcont;
  cont.flags = M_COMPLETE;
  FD_ZERO(&fds);
  FD_SET(0, &fds);
  FD_SET(1, &fds);
  FD_SET(2, &fds);
  /* cont.fds = &fds; */
  return &cont;
}

int
main(int argc, char *argv[])
{
    struct hostent *hostptr;
    struct sockaddr_in addr;
    char * sockstr = getenv("MIGRATE_CONT");
    int sock;
    socklen_t len;
    migrate_session *session;
    int i = 0;

    if(sockstr) {
	char buff[25];
	sock = atoi(sockstr);
	if(!(session = migrate_get_session(sock))) {
	  fprintf(stderr, "migrate_get_session for fd %d failed: %s\n", sock,
		  strerror(errno));
	  exit(1);
	}
	
	MIGRATE_RESTORE(session, i);
	sprintf(buff, "I back with i %d\n", i);
	write(4, buff, strlen(buff)+1);
	exit(0);
    }
	    	
    if(argc!=3) {
	fprintf(stderr, "Need hostname and port\n");
	exit(1);
    }

    i = 5;

    sock = socket(AF_INET, SOCK_STREAM, 0); 

    /* Open network listening socket */
    memset(&addr, 0, sizeof(addr));
    addr.sin_family = AF_INET;
    addr.sin_addr.s_addr = INADDR_ANY;
    addr.sin_port = htons(atoi(argv[2]));

    if ((hostptr = gethostbyname(argv[1]))==NULL) {
	fprintf(stderr, "Unknown host %s.\n", argv[1]);
	exit(1);
    }

    memset(&addr, 0, sizeof(addr));
    addr.sin_family = hostptr->h_addrtype;
    memcpy(&addr.sin_addr, hostptr->h_addr, hostptr->h_length);
    addr.sin_port = htons(atoi(argv[2]));
  
    printf("Trying to connect to port %d (%s)...\n", atoi(argv[2]),
	   argv[1]);
    if(connect(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
	printf("connect: %s\n", strerror(errno));
	exit(1);
    }
    getpeername(sock, (struct sockaddr *)&addr, &len);
    printf("Connected to %s:%hu\n", inet_ntoa(addr.sin_addr),
	   ntohs(addr.sin_port));

    if(!(session = migrate_get_session(sock))) {
      fprintf(stderr, "migrate_get_session failed: %s\n",
	      strerror(errno));
      exit(1);
    }
    
    if(MIGRATE_SAVE(session, i))
      fprintf(stderr, "Migrate save: %s\n", strerror(errno));

    fprintf(stderr, "Saving i as %d for fd %d\n", i, sock);

    if(migrate_register_handler(session, mobhandler)) {
      fprintf(stderr, "register_handler failed: %s\n", strerror(errno));
      exit(1);
    }

    for(;;);
}

