#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif
#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif

int
main(int argc, char *argv[])
{
  struct hostent *hostptr;

  struct sockaddr_in addr;
  int sock,  conn = 0;
  socklen_t len = sizeof(addr);
  int port;
  char c;
  int retval, res = 0;
  fd_set fds;
  int bufsize;

  if(argc!=3) {
    fprintf(stderr, "Need port and hostname\n");
    exit(1);
  }

  port = atoi(argv[1]);

  sock = socket(AF_INET, SOCK_DGRAM, 0); 

  /* Open network listening socket */
  memset(&addr, 0, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = INADDR_ANY;
  addr.sin_port = htons(port);

  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_RCVBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket rcv buffer size: %d\n", bufsize);
  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_SNDBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket snd buffer size: %d\n", bufsize);

  if(bind(sock, (struct sockaddr *)&addr, sizeof(addr))) {
    printf("bind: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }

  if ((hostptr = gethostbyname(argv[2]))==NULL) {
    fprintf(stderr, "Unknown host %s.\n", argv[1]);
    exit(1);
  }
  
  /* Open network listening socket */
  memset(&addr, 0, sizeof(addr));
  addr.sin_family = hostptr->h_addrtype;
  memcpy(&addr.sin_addr, hostptr->h_addr, hostptr->h_length);
  addr.sin_port = htons(0);
  len = sizeof(addr);

 /* if(connect(sock, (struct sockaddr *)&addr, len) < 0) {
    fprintf(stderr, "connect: %s\n", strerror(errno));
    exit(1);
  } 
  printf("Connected to %s:%hu\n", inet_ntoa(addr.sin_addr),
	 ntohs(addr.sin_port));
 */

  getsockname(sock, (struct sockaddr *)&addr, &len);
  printf("Socket local addr %s:%hu\n", inet_ntoa(addr.sin_addr),
	 ntohs(addr.sin_port));

  conn = 1;
  
  printf("We'll die on keystroke.\n");

  FD_ZERO(&fds);
  FD_SET(sock, &fds);
  FD_SET(STDIN_FILENO, &fds);
  while((retval = select(sock + 1, &fds, NULL, NULL, NULL)) > 0){
    if(FD_ISSET(STDIN_FILENO, &fds))
       break;
    if (!conn) {
      printf("Accepting connection\n");
      len = sizeof(addr);
      if((res = recvfrom(sock, &c, 1, 0, (struct sockaddr *)&addr, &len))<0) {
	fprintf(stderr, "recvfrom: %s\n", strerror(errno));
	exit(1);
      }
    } else
      res = read(sock, &c, 1);
    if (res < 0)
      printf("Read: %s\n", strerror(errno));    
    else if (!res) {
      fprintf(stderr, "Read returned EOF, exiting...\n");
      break;
    } else {
      printf("%c", c);
      fflush(stdout);
    }
    FD_SET(sock, &fds);
    FD_SET(STDIN_FILENO, &fds);
  }
  if (retval < 0)
    fprintf(stderr, "select: %s\n", strerror(errno));

  printf("exiting...");
  close(sock);
  return 0;
}
