#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif
#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif

#include <migrate.h>

int
main(int argc, char *argv[])
{
  struct sockaddr_in addr;
  int sock, newsock;
  socklen_t len = sizeof(addr);
  int port;
  char c;
  int retval, res = 0;
  fd_set fds;
  int bufsize;
  struct hostent *hostptr;
  struct sockaddr_in maddr;

  if(argc!=3) {
    fprintf(stderr, "Need port and hostname\n");
    exit(1);
  }

  port = atoi(argv[1]);

  if ((hostptr = gethostbyname(argv[2]))==NULL) {
    fprintf(stderr, "Unknown host %s.\n", argv[2]);
    exit(1);
  }
  
  /* Prepare migrate address */
  memset(&maddr, 0, sizeof(maddr));
  maddr.sin_family = hostptr->h_addrtype;
  memcpy(&maddr.sin_addr, hostptr->h_addr, hostptr->h_length);
  maddr.sin_port = 0;

  sock = socket(AF_INET, SOCK_STREAM, 0); 

  /* Open network listening socket */
  memset(&addr, 0, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = INADDR_ANY;
  addr.sin_port = htons(port);

  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_RCVBUF, &bufsize, &len)) {
    fprintf(stderr,"getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  fprintf(stderr,"Socket rcv buffer size: %d\n", bufsize);
  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_SNDBUF, &bufsize, &len)) {
    fprintf(stderr,"getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  fprintf(stderr,"Socket snd buffer size: %d\n", bufsize);

  if(bind(sock, (struct sockaddr *)&addr, sizeof(addr))) {
    fprintf(stderr,"bind: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }

  len = sizeof(struct sockaddr_in);
  if(getsockname(sock, (struct sockaddr *)&addr, &len)) {
    fprintf(stderr,"bind: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  
  fprintf(stderr,"Listening on port %s:%hu...\n", 
	inet_ntoa(addr.sin_addr), ntohs(addr.sin_port));
  if(listen(sock, 0)) {
    fprintf(stderr,"listen: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }

  fprintf(stderr,"Accepting connection\n");
  len = sizeof(addr);
  newsock = accept(sock, (struct sockaddr *)&addr, &len);
  if(newsock < 0) {
    fprintf(stderr, "Accept: %s\n", strerror(errno));
    exit(1);
  }
  fprintf(stderr,"Connected to %s:%hu\n", inet_ntoa(addr.sin_addr),
	 ntohs(addr.sin_port));

  len = sizeof(bufsize);
  if (getsockopt(newsock, SOL_SOCKET, SO_RCVBUF, &bufsize, &len)) {
    fprintf(stderr,"bind: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  fprintf(stderr,"Socket rcv buffer size: %d\n", bufsize);
  len = sizeof(bufsize);
  if (getsockopt(newsock, SOL_SOCKET, SO_SNDBUF, &bufsize, &len)) {
    fprintf(stderr,"bind: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  fprintf(stderr,"Socket snd buffer size: %d\n", bufsize);

  fgetc(stdin);
  fprintf(stderr,"We'll die when the connection does.\n");

  FD_ZERO(&fds);
  FD_SET(newsock, &fds);
  while((retval = select(newsock + 1, &fds, NULL, NULL, NULL)) > 0){
    res = read(newsock, &c, 1);
    if (res < 0) 
      fprintf(stderr,"Read: %s\n", strerror(errno));    
    else if (!res) {
      fprintf(stderr, "Read returned EOF, exiting...\n");
      break;
    } else {
      printf("%c", c);
      fflush(stdout);
      if(migrate_avail())
	switch(c) {
	case 'm':
	  {
	    migrate_session *session = migrate_get_session(newsock);
	    fprintf(stderr, "\nMigrating to %s", inet_ntoa(maddr.sin_addr));
	    if(migrate_migrate(session, (struct sockaddr *)&maddr,
			       sizeof(maddr)))
	      fprintf(stderr, "migrate: %s", strerror(errno));
	    free(session);
	    break;
	  }
	case 'f':
	  {
	    migrate_session *session = migrate_get_session(newsock);
	    fprintf(stderr, "\nSuspending");
	    if(migrate_freeze(session))
	      fprintf(stderr, "freeze: %s", strerror(errno));
	    free(session);
	    break;
	  }
	default:
	}
    }

  }
  if (retval < 0)
    fprintf(stderr, "serv select: %s\n", strerror(errno));

  close(sock);
  close(newsock);
  return 0;
}
