#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif

#include <migrate.h>

int main()
{
        char *blah = "I say blah";
	int i = 5;
	migrate_session *session;

	int sock = socket(AF_INET, SOCK_STREAM, 0); 

	if(!migrate_avail()) {
	  fprintf(stderr, "TESLA Migrate handler not available, exiting...\n");
	  exit(1);
	}

	if(!(session = migrate_session_create(sock, M_AUTOCLOSE))) {
	  fprintf(stderr, "migrate_session_create failed: %s\n",
		  strerror(errno));
	  exit(1);
	}
	
	if(MIGRATE_SAVE(session, i))
	  fprintf(stderr, "Migrate save: %s\n", strerror(errno));

	if(MIGRATE_STRSAVE(session, blah))
	  fprintf(stderr, "Migrate save: %s\n", strerror(errno));

	printf("i: %d\t blah: %s\n",i, blah);

	i = 3;
	blah = "";
	printf("i: %d\t blah: %s\n",i, blah);

	if(!MIGRATE_RESTORE(session, i))
	  fprintf(stderr, "Migrate retrieve: %s\n", strerror(errno));
	if(!(blah = MIGRATE_STRRESTORE(session, blah)))
	  fprintf(stderr, "Migrate retrieve: %s\n", strerror(errno));

	printf("i: %d\t blah: %s\n", i, blah);

	if(migrate_session_close(session))
	  fprintf(stderr, "Migrate close: %s\n", strerror(errno));

	if(close(sock))
	  fprintf(stderr, "close: %s\n", strerror(errno));

	return 0;
}

