#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif
#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif
#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

int
main(int argc, char *argv[])
{
  struct hostent *hostptr;
  struct sockaddr_in addr;
  int sock, res;
  socklen_t len;
  char ch;
  pid_t pid;
  size_t bufsize;

  if(argc!=3) {
    fprintf(stderr, "Need hostname and port\n");
    exit(1);
  }

  sock = socket(AF_INET, SOCK_DGRAM, 0); 

  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_RCVBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket rcv buffer size: %d\n", bufsize);
  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_SNDBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket snd buffer size: %d\n", bufsize);


  /* Open network listening socket */
  memset(&addr, 0, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = INADDR_ANY;
  addr.sin_port = 0;

  /* bind(sock, (struct sockaddr *)&addr, sizeof(addr)); */

  if ((hostptr = gethostbyname(argv[1]))==NULL) {
    fprintf(stderr, "Unknown host %s.\n", argv[1]);
    exit(1);
  }
  
  /* Open network listening socket */
  memset(&addr, 0, sizeof(addr));
  addr.sin_family = hostptr->h_addrtype;
  memcpy(&addr.sin_addr, hostptr->h_addr, hostptr->h_length);
  addr.sin_port = htons(atoi(argv[2]));
  
  printf("Trying to connect to port 25...\n");
  /*if(connect(sock, (struct sockaddr *)&addr, sizeof(addr)))
    printf("connect: %s\n", strerror(errno)); */
  getpeername(sock, (struct sockaddr *)&addr, &len);
  getsockopt(sock, SOL_SOCKET, SO_SNDBUF, &bufsize, &len);
  printf("Connected to %s:%hu with %d\n", inet_ntoa(addr.sin_addr),
	 ntohs(addr.sin_port), bufsize);

  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_RCVBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket rcv buffer size: %d\n", bufsize);
  len = sizeof(bufsize);
  if (getsockopt(sock, SOL_SOCKET, SO_SNDBUF, &bufsize, &len)) {
    printf("getsockopt: %s\n", strerror(errno));
    close(sock);
    exit(1);
  }
  printf("Socket snd buffer size: %d\n", bufsize);

  if ((pid = fork())) {
    fprintf(stderr, "Forked child %d, we're done.\n", pid);
    close(sock);
    wait(NULL);

  } else {

  again:
    while((res = read(0, &ch, 1)) == 1)
      sendto(sock, &ch, 1, 0, (const struct sockaddr *)&addr, sizeof(addr));
    if (res == -1) {
      perror("read");
	if(errno==EIO)
	exit(1);
      goto again;
    }
    close(sock);
    printf("Hit any key to exit...\n");
    getchar();
  }

  return 0;
}





