/*
 * Migrate Session Layer
 *
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: fdpass.c,v 1.2 2002/05/31 17:46:20 snoeren Exp $
 */


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <string.h>
# include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
#ifdef HAVE_SYS_UIO_H
# include <sys/uio.h>
#endif

#include <fdpass.h>


/* Receive message with file descriptor */

int
rcvfd(int passfd, void *data, unsigned int *datalen)
{
    char cbuf[CMSG_SPACE(sizeof(int))]; 
    struct msghdr mh = {0};
    struct cmsghdr *cm;
    int *dp,ret; 
    struct iovec iov; 
  
    if (data) { 
	mh.msg_iov = &iov; 
	mh.msg_iovlen = 1;
	iov.iov_base = data; 
	iov.iov_len = *datalen; 
    }
  
    mh.msg_control = cbuf;
    mh.msg_controllen = sizeof(cbuf); 
    cm = CMSG_FIRSTHDR(&mh); 
    cm->cmsg_len = CMSG_LEN(sizeof(int)); 
    cm->cmsg_level = SOL_SOCKET;
    cm->cmsg_type = SCM_RIGHTS; 
  
    *datalen = 0; 
    ret = recvmsg(passfd, &mh, 0); 
    if (ret < 0) 
	return ret; 
    if (datalen) *datalen = ret; 
  
    dp = (int *)CMSG_DATA(cm); 
    return *dp;
}
