/*
 * Migrate Session Layer
 *
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2002 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * A very simple list.
 *
 * $Id: list.c,v 1.3 2002/07/17 12:03:45 snoeren Exp $
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef STDC_HEADERS
# include <string.h>
# include <stdlib.h>
#endif
#ifdef HAVE_ASSERT_H
# include <assert.h>
#endif

#include "list.h"

void *
_list_find(const struct _list_t *head, const void *match,
	   int (*pred)(const void *, const void *))
{
  const struct _list_t *curr = head;

  while(curr) {
    if(pred(match, curr->data))
      return curr->data;
    curr = curr->next;
  }
  return NULL;
}

void
_delete_list(struct _list_t **head)
{
  struct _list_t *next, *curr = *head;
  
  while(curr) {
    next = curr->next;
    free(curr);
    curr = next;
  }
  *head = NULL;
}

void
_list_add(struct _list_t **head, void *data)
{
  struct _list_t *elem = (struct _list_t *)malloc(sizeof(struct _list_t));
  
  elem->data = data;
  elem->next = *head;
  *head = elem;
}

void
_list_add_tail(struct _list_t **head, void *data)
{
  if(!(*head))
    return _list_add(head, data);

  while((*head)->next) {
    head = (struct _list_t **)&((*head)->next);
  }

  (*head)->next = malloc(sizeof(struct _list_t));
  ((struct _list_t *)(*head)->next)->data = data;
  ((struct _list_t *)(*head)->next)->next = NULL;
}

void
_list_append(struct _list_t **head, struct _list_t *remainder)
{
  if(!(*head)) {
    *head = remainder;
    return;
  }

  while((*head)->next) {
    head = (struct _list_t **)&((*head)->next);
  }

  (*head)->next = remainder;
}

void
_list_del(struct _list_t **head, void *data)
{
  struct _list_t *prev = NULL;
  struct _list_t *curr = *head;

  /* Can't delete from an empty list */
  if(!curr)
    return;

  while(curr->data != data) {
    prev = curr;
    curr = curr->next;
    if(!curr)
      return;
  }

  if(curr == *head)
    *head = curr->next;
  else
    prev->next = curr->next;

  free(curr);
}
