/*
 * Migrate Session Layer
 *
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2002 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: list.h,v 1.3 2002/07/17 12:03:45 snoeren Exp $
 */

#ifndef _LIST_H
#define _LIST_H

struct _list_t {
  void *data;
  void *next;
};

void _list_append(struct _list_t **, struct _list_t *);
void _list_add(struct _list_t **, void *);
void _list_add_tail(struct _list_t **, void *);
void _list_del(struct _list_t **, void *);
void _delete_list(struct _list_t **);
void * _list_find(const struct _list_t *head, const void *match,
		  int (*pred)(const void *, const void *));

#endif /* _LIST_H */



