#ifndef _DEBUG_H_
#define _DEBUG_H_

#ifdef DEBUG
extern unsigned int debug;
#define DPRINTF(level, fmt, args...) \
        do { if (debug & level) fprintf(stderr, fmt , ##args ); } while(0)
#else
#define DPRINTF(args...)
#endif

#define DEBUG_NONE      0x01
#define DEBUG_INIT      0x01
#define DEBUG_REQUESTS  0x02
#define DEBUG_PROCESSES 0x04
#define DEBUG_TCP       0x08
#define DEBUG_ANNOUNCE  0x10
#define DEBUG_HTTP      0x20
#define DEBUG_PERF      0x40
#define DEBUG_REMOTE    0x80
#define DEBUG_DEATH     0x100
#define DEBUG_ALL       0xffffffff

#endif /* _DEBUG_H_ */
