/*
 * Manage the pid / process hash table map.
 */

#ifndef _HASH_H
#define _HASH_H

#ifdef TEST_HASH
struct htest {
	char stuff[256];
};
typedef struct htest stored_t;
#endif

#include "wedge.h"
typedef struct remcon stored_t;

typedef void (*hash_free_t)(stored_t *);
typedef int  hkey_t;

struct htable_entry {
	hkey_t key;
	stored_t *item;
	struct htable_entry *next;
};
	
struct hashtype {
	int hash_nbuckets;
	int hash_size;
	hash_free_t freeproc;

	struct htable_entry **contents;
};

struct hashtype *hash_create(int hash_buckets, hash_free_t freeproc);

/* Destroys the hash;  calls freeproc on all items in it. */
void hash_destroy(struct hashtype *A);

int hash_insert(struct hashtype *A, hkey_t key, stored_t *newitem);

/* Returns the item removed - you should free it yourself */
stored_t *hash_remove(struct hashtype *A, hkey_t key);

/* Number of items currently stored in the hash */
int hash_size(struct hashtype *A);

/* Find item with key "key" in the hash.  Leaves the hash untouched */
stored_t *hash_find(struct hashtype *A, hkey_t key);

#endif /* _HASH_H */
