/*
 * Send a "wedge died" message
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/signal.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <linux/unistd.h>
#include <assert.h>
#include <string.h>
#include <netdb.h>
#include "wedge.h"
#include "debug.h"

struct server *servers = NULL;	/* The remote servers we know about */

inline struct listel *serv_to_list(struct server *a) {
    return (struct listel *)a;
}

inline struct server *list_to_serv(struct listel *a) {
    return (struct server *)a;
}

struct server *
add_server(struct sockaddr_in sockaddr)
{
    struct server *newserver;

    newserver = malloc(sizeof(*newserver));
    if (!newserver) {
	perror("could not allocate server struct");
	return NULL;
    }
    newserver->con_list = NULL;
    newserver->con_tail = NULL;
    newserver->sockaddr = sockaddr;
    newserver->head.prev = NULL;
    newserver->head.next = serv_to_list(servers);
    if (servers) {
	servers->head.prev = serv_to_list(newserver);
    }
    servers = newserver;
    return newserver;
}

int
read_servers(char *server_filename)
{
    FILE *infile;
    char inbuf[512];
    struct hostent *he;
    struct sockaddr_in sockaddr;
    char *retpos;


    infile = fopen(server_filename, "r");
    if (!infile) {
	perror(server_filename);
	return -1;
    }
    while (fgets(inbuf, sizeof(inbuf)-1, infile) != NULL) {
	bzero(&sockaddr, sizeof(sockaddr));
	retpos = strchr(inbuf, '\n');
	if (retpos) *retpos = '\0';
	
	if (!inet_aton(inbuf, &(sockaddr.sin_addr))) {
	    he = gethostbyname(inbuf);
	    if (!he) {
		herror(inbuf);
		continue; /* Just skip the name... */
	    }
	    memcpy(&(sockaddr.sin_addr), he->h_addr, he->h_length);
	}
	sockaddr.sin_port = htons(ANNOUNCE_PORT);
	sockaddr.sin_family = AF_INET;
#ifndef NO_SIN_LEN
	sockaddr.sin_len = sizeof(sockaddr);
#endif
	/* Okay, resolved */
	add_server(sockaddr);
    }
    return 0;
}

void
usage()
{
    fprintf(stderr,
	    "usage:  kill-wedge [-h] [-s serverfile] [host-that-died]\n"
	    );
}

void help()
{
    usage();
}

int
main(int argc, char **argv) {
    char *dead_server = "squall.lcs.mit.edu";

    struct hostent *he;
    struct sockaddr_in sockaddr, localport;
    int sock;
    struct server *shead;
    struct wedge_header msg;
    char *server_file = DEFAULT_SERVER_FILE_NAME;

    extern char *optarg;
    extern int optind;
    int ch;

    while ((ch = getopt(argc, argv, "hs:")) != -1)
	switch(ch) {
	case 'h':
	    help();
	    exit(0);
	case 's':
	    server_file = optarg;
	    break;
	}

    argc -= optind;
    argv += optind;

    if (argc > 0) {
	dead_server = argv[0];
    }

    read_servers(server_file);

    sock = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if (sock < 0) {
	perror("announce UDP socket");
	exit(-1);
    }

    bzero(&sockaddr, sizeof(sockaddr));
    bzero(&localport, sizeof(localport));

    localport.sin_addr.s_addr = INADDR_ANY;
    localport.sin_port = 6883; /* shrug */
    localport.sin_family = AF_INET;

    if (bind(sock, (struct sockaddr *)&localport,
	     sizeof(localport)) == -1) {
	perror("binding local sock");
	exit(-1);
    }
    
    if (!inet_aton(dead_server, &(sockaddr.sin_addr))) {
	he = gethostbyname(dead_server);
	if (!he) {
	    herror(dead_server);
	    exit(-1);
	}
	memcpy(&(sockaddr.sin_addr), he->h_addr, he->h_length);
    }

    msg.version = 1;
    msg.cmd = htonl(CMD_DEATH);
    msg.remhost = sockaddr.sin_addr.s_addr;
    msg.numcons = 0; /* shrug */

    shead = servers;
    while (shead != NULL) {
	fprintf(stderr, "Sending died message to %s %d\n",
	       inet_ntoa(shead->sockaddr.sin_addr),
		ntohs(shead->sockaddr.sin_port));
	if (sendto(sock, &msg, sizeof(msg), 0,
		   (struct sockaddr *)&shead->sockaddr,
		   sizeof(shead->sockaddr)) != sizeof(msg)) {
	    perror("sendto");
	}
	shead = list_to_serv(shead->head.next);
    }
    printf("Sent kill message\n");
    
    exit(0);
}
